const state = {
  throttleValue: 0, //油门值
};

const mutations = {
  /**
   * 单纯的给state赋值
   * @param {*} param0
   * @param {*} data {key: '', value}
   */
  setState(state, data) {
    try {
      state[data.key] = data.value;
    } catch (e) {
      console.log("setDate err", e);
    }
  },
};

const actions = {};

const getters = {
  /**
   * //油门是否置中
   * @param {*} state 
   * @returns 
   */
  isThrottleCenter(state){
    if (state.throttleValue >= 470 && state.throttleValue <= 530) {
      return true;
    } else {
      return false;
    }
  }
};

export default {
  namespaced: true,
  name: "uav",
  state,
  mutations,
  actions,
  getters,
};
