import Vue from 'vue'
import Vuex from 'vuex'; 
import App from './index.vue'
import router from "./router";
import store from './store';
import VueRouter from "vue-router";
import ElementUI from "element-ui";
import "element-ui/lib/theme-chalk/index.css";
import MMCSTL from '../../../index';

/**
 * 基于元素挂载飞控中心
 * @param {String | Element} elementOrSelector 元素的id或者元素对象
 * @param {Object} options 额外参数
 * @param {Boolean} options.hasVuex 是否已加载Vuex
 * @param {Boolean} options.hasVueRouter 是否已加载VueRouter
 * @param {Boolean} options.hasElementUI 是否已加载hasElementUI
 * @param {Boolean} options.hasMMCSTLVue2 是否已加载MMC-stl-vue2
 */
export default function main(elementOrSelector, options = {}){
  console.log('Vue2', Vue.prototype.$store, Vue.config.optionMergeStrategies.beforeRouteEnter, Vue.prototype.$ELEMENT);
  // if(!options.hasVuex){
    Vue.use(Vuex);
  // }
  if(!options.hasVueRouter){
    Vue.use(VueRouter);
  }
  if(!options.hasElementUI){
    Vue.use(ElementUI);
  }
  if(!options.hasMMCSTLVue2){
    Vue.use(MMCSTL);
  }
  if(!window.$mmc_stl){
    window.$mmc_stl = {};
  }
  window.$mmc_stl.$store = new Vuex.Store(store);
  return new Vue({
    render: (h) => h(App),
    router,
    store: window.$mmc_stl.$store,
  }).$mount(elementOrSelector);
}





