package com.example.rabbitmqtest.rabbitmq;

import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.core.RabbitTemplate.ReturnCallback;
import org.springframework.stereotype.Component;

@Component
public class ReturnCallBack implements ReturnCallback {

    /**
     * @param message    发生异常时的消息
     * @param replyCode  回复代码
     * @param replyText  回复文本
     * @param exchange   交换机
     * @param routingKey 路由键
     */
    @Override
    public void returnedMessage(Message message, int replyCode, String replyText, String exchange, String routingKey) {
        System.out.println("失败消息："+message+"\n回复代码："+replyCode+"\n回复信息："+replyText+"\n交换机："+exchange+"\n路由键："+routingKey);
    }

}
