package com.example.rabbitmqtest.rabbitmq;

import javax.annotation.Resource;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitmqConfig {

    public static final String FANOUT_QUEUE = "test-queue";//队列名称1
    public static final String FANOUT_QUEUE2 = "test-queue2";//队列名称2
    public static final String FANOUT_EXCHANGE = "fanoutExchange";//交换机名称

    @Resource
    ConfirmCallBack confirmCallBack;
    @Resource
    ReturnCallBack returnCallBack;

    //获取连接工厂
    @Bean
    public ConnectionFactory connectionFactory() {
        CachingConnectionFactory factory = new CachingConnectionFactory();
        factory.setHost("127.0.0.1");
        factory.setUsername("rin");
        factory.setPassword("123");
        factory.setPort(5672);
        factory.setPublisherConfirms(true);//开启消息发送失败重试机制
        factory.setPublisherReturns(true);//开启消息回调
        return factory;
    }

    //注入到模板
    @Bean
    public RabbitTemplate rabbitTemplate() {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory());
        rabbitTemplate.setConfirmCallback(confirmCallBack);//设置消息回调的类
        rabbitTemplate.setReturnCallback(returnCallBack);//设置消息发送失败的类
        return rabbitTemplate;
    }

    //设置队列
    @Bean
    public Queue testQueue() {
        return new Queue(FANOUT_QUEUE);
    }
    @Bean
    public Queue testQueue2() {
        return new Queue(FANOUT_QUEUE2);
    }

    //设置交换机(广播模式)
    @Bean
    public FanoutExchange myFanoutExchange() {
        return new FanoutExchange(FANOUT_EXCHANGE);
    }

    //绑定
    @Bean
    public Binding myBinding() {
        return BindingBuilder
            .bind(testQueue())//把这个队列绑定到交换机上去
            .to(myFanoutExchange());
    }
    @Bean
    public Binding myBinding2() {
        return BindingBuilder
            .bind(testQueue2())//把这个队列绑定到交换机上去
            .to(myFanoutExchange());
    }
}
