package com.example.rabbitmqtest.rabbitmq;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
public class Consumer {

    @RabbitListener(queues = "test-queue")
    public void consumeMsg(String msg, Channel channel, Message message) {
        try {
            System.out.println("消费者1已成功消费消息---------" + msg);
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
        } catch (IOException e) {
            System.out.println("消费者1消费消息失败---------" + msg);
            try {
                channel.basicReject(message.getMessageProperties().getDeliveryTag(), false);
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @RabbitListener(queues = "test-queue2")
    public void consumeMsg2(String msg, Channel channel, Message message) {
        try {
            System.out.println("消费者2已成功消费消息---------" + msg);
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
        } catch (IOException e) {
            System.out.println("消费者2消费消息失败---------" + msg);
            try {
                channel.basicReject(message.getMessageProperties().getDeliveryTag(), false);
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}
