package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.result.TaskListVo;
import com.mmc.tmj.entity.result.TaskSelectVo;
import com.mmc.tmj.utils.builder.statement.TaskListVoStatementTmBuilder;
import com.mmc.tmj.utils.builder.statement.TaskSelectVoStatementTmBuilder;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/9 10:19
 * @Version 1.0
 * @description
 */
public class TaskSelectVoTmBuilder extends TaskSelectVoStatementTmBuilder<TaskSelectVo> {

    public static TaskSelectVoTmBuilder getInstance(){
        return new TaskSelectVoTmBuilder();
    }

    @Override
    public TaskSelectVo getObject() {
        return taskSelectVo;
    }

    @Override
    public TaskSelectVoTmBuilder init(TaskSelectVo object) {
        this.taskSelectVo=object;
        return this;
    }

    @Override
    public TaskSelectVoTmBuilder init() {
        this.taskSelectVo=new TaskSelectVo();
        return this;
    }

    @Override
    public TaskSelectVoTmBuilder buildId(Integer id) {
        Optional.ofNullable(id).ifPresent(inte ->{
            this.taskSelectVo.setId(inte);
        });
        return this;
    }

    @Override
    public TaskSelectVoTmBuilder buildTaskName(String taskName) {
        Optional.ofNullable(taskName).ifPresent(inte ->{
            this.taskSelectVo.setTaskName(inte);
        });
        return this;
    }


}
