package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.result.TaskReportDto;
import com.mmc.tmj.utils.builder.statement.TaskReportDtoStatementTmBuilder;
import java.time.LocalDateTime;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/18 14:11
 * @Version 1.0
 * @description
 */
public class TaskReportDtoTmBuilder extends TaskReportDtoStatementTmBuilder<TaskReportDto> {
    public static TaskReportDtoTmBuilder getInstance(){
        return new TaskReportDtoTmBuilder();
    }
    @Override
    public TaskReportDto getObject() {
        return taskReportDto;
    }

    @Override
    public TaskReportDtoTmBuilder init(TaskReportDto object) {
        taskReportDto=object;
        return this;
    }

    @Override
    public TaskReportDtoTmBuilder init() {
        taskReportDto = new TaskReportDto();
        return this;
    }

    @Override
    public TaskReportDtoTmBuilder buildTaskId(Integer taskId) {
        Optional.ofNullable(taskId).ifPresent(inte ->{
            this.taskReportDto.setTaskId(inte);
        });
        return this;
    }

    @Override
    public TaskReportDtoTmBuilder buildTaskName(String taskName) {
        Optional.ofNullable(taskName).ifPresent(inte ->{
            this.taskReportDto.setTaskName(inte);
        });
        return this;
    }

    @Override
    public TaskReportDtoTmBuilder buildLocation(String location) {
        Optional.ofNullable(location).ifPresent(inte ->{
            this.taskReportDto.setLocation(inte);
        });
        return this;
    }

    @Override
    public TaskReportDtoTmBuilder buildStartTime(LocalDateTime startTime) {
        Optional.ofNullable(startTime).ifPresent(inte ->{
            this.taskReportDto.setStartTime(inte);
        });
        return this;
    }

    @Override
    public TaskReportDtoTmBuilder buildEndTime(LocalDateTime endTime) {
        Optional.ofNullable(endTime).ifPresent(inte ->{
            this.taskReportDto.setEndTime(inte);
        });
        return this;
    }

    @Override
    public TaskReportDtoTmBuilder buildTaskDate(LocalDateTime taskDate) {
        Optional.ofNullable(taskDate).ifPresent(inte ->{
            this.taskReportDto.setTaskDate(inte);
        });
        return this;
    }

    @Override
    public TaskReportDtoTmBuilder buildWeather(String weather) {
        Optional.ofNullable(weather).ifPresent(inte ->{
            this.taskReportDto.setWeather(inte);
        });
        return this;
    }

    @Override
    public TaskReportDtoTmBuilder buildDeviceHardId(String deviceHardId) {
        Optional.ofNullable(deviceHardId).ifPresent(inte ->{
            this.taskReportDto.setDeviceHardId(inte);
        });
        return this;
    }

    @Override
    public TaskReportDtoTmBuilder buildExecutePerson(String executePerson) {
        Optional.ofNullable(executePerson).ifPresent(inte ->{
            this.taskReportDto.setExecutePerson(inte);
        });
        return this;
    }

    @Override
    public TaskReportDtoTmBuilder buildReportAddTime(LocalDateTime reportAddTime) {
        Optional.ofNullable(reportAddTime).ifPresent(inte ->{
            this.taskReportDto.setReportAddTime(inte);
        });
        return this;
    }

    @Override
    public TaskReportDtoTmBuilder buildRemark(String remark) {
        Optional.ofNullable(remark).ifPresent(inte ->{
            this.taskReportDto.setRemark(inte);
        });
        return this;
    }
}
