package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.database.TaskDto;
import com.mmc.tmj.entity.result.TaskListVo;
import com.mmc.tmj.utils.builder.statement.TaskDoStatementTmBuilder;
import com.mmc.tmj.utils.builder.statement.TaskListVoStatementTmBuilder;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/9 10:19
 * @Version 1.0
 * @description
 */
public class TaskListVoTmBuilder extends TaskListVoStatementTmBuilder<TaskListVo> {

    public static TaskListVoTmBuilder getInstance(){
        return new TaskListVoTmBuilder();
    }

    @Override
    public TaskListVo getObject() {
        return taskDto;
    }

    @Override
    public TaskListVoTmBuilder init(TaskListVo object) {
        this.taskDto=object;
        return this;
    }

    @Override
    public TaskListVoTmBuilder init() {
        this.taskDto=new TaskListVo();
        return this;
    }

    @Override
    public TaskListVoTmBuilder buildId(Integer id) {
        Optional.ofNullable(id).ifPresent(inte ->{
            this.taskDto.setId(inte);
        });
        return this;
    }

    @Override
    public TaskListVoTmBuilder buildTaskName(String taskName) {
        Optional.ofNullable(taskName).ifPresent(inte ->{
            this.taskDto.setTaskName(inte);
        });
        return this;
    }

    @Override
    public TaskListVoTmBuilder buildRouteName(String routeName) {
        Optional.ofNullable(routeName).ifPresent(inte ->{
            this.taskDto.setRouteName(inte);
        });
        return this;
    }

    @Override
    public TaskListVoTmBuilder buildOrganizationName(String organizationName) {
        Optional.ofNullable(organizationName).ifPresent(inte ->{
            this.taskDto.setOrganizationName(inte);
        });
        return this;
    }

    @Override
    public TaskListVoTmBuilder buildDeviceId(Integer deviceId) {
        Optional.ofNullable(deviceId).ifPresent(inte ->{
            this.taskDto.setDeviceId(inte);
        });
        return this;
    }

    @Override
    public TaskListVoTmBuilder buildDeviceName(String deviceName) {
        Optional.ofNullable(deviceName).ifPresent(inte ->{
            this.taskDto.setDeviceName(inte);
        });
        return this;
    }

    @Override
    public TaskListVoTmBuilder buildDeviceHardId(String deviceHardId) {
        Optional.ofNullable(deviceHardId).ifPresent(inte ->{
            this.taskDto.setDeviceHardId(inte);
        });
        return this;
    }


    @Override
    public TaskListVoTmBuilder buildDeviceStatus(Integer deviceStatus) {
        Optional.ofNullable(deviceStatus).ifPresent(inte ->{
            this.taskDto.setDeviceStatus(inte);
        });
        return this;
    }

    @Override
    public TaskListVoTmBuilder buildTaskStatus(Integer taskStatus) {
        Optional.ofNullable(taskStatus).ifPresent(inte ->{
            this.taskDto.setTaskStatue(inte);
        });
        return this;
    }

    @Override
    public TaskListVoTmBuilder buildCreateWhen(String createWhen) {
        Optional.ofNullable(createWhen).ifPresent(inte ->{
            this.taskDto.setCreateWhen(inte);
        });
        return this;
    }


}
