package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.result.TaskInfoVo;
import com.mmc.tmj.entity.result.TaskSelectVo;
import com.mmc.tmj.utils.builder.statement.TaskInfoVoStatementTmBuilder;
import com.mmc.tmj.utils.builder.statement.TaskSelectVoStatementTmBuilder;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/9 10:19
 * @Version 1.0
 * @description
 */
public class TaskInfoVoTmBuilder extends TaskInfoVoStatementTmBuilder<TaskInfoVo> {

    public static TaskInfoVoTmBuilder getInstance(){
        return new TaskInfoVoTmBuilder();
    }

    @Override
    public TaskInfoVo getObject() {
        return taskInfoVo;
    }

    @Override
    public TaskInfoVoTmBuilder init(TaskInfoVo object) {
        this.taskInfoVo=object;
        return this;
    }

    @Override
    public TaskInfoVoTmBuilder init() {
        this.taskInfoVo=new TaskInfoVo();
        return this;
    }

    @Override
    public TaskInfoVoTmBuilder buildRouteName(String routeName) {
        Optional.ofNullable(routeName).ifPresent(inte ->{
            this.taskInfoVo.setRouteName(inte);
        });
        return this;
    }


    @Override
    public TaskInfoVoTmBuilder buildTaskName(String taskName) {
        Optional.ofNullable(taskName).ifPresent(inte ->{
            this.taskInfoVo.setTaskName(inte);
        });
        return this;
    }

    @Override
    public TaskInfoVoTmBuilder buildDeviceName(String deviceName) {
        Optional.ofNullable(deviceName).ifPresent(inte ->{
            this.taskInfoVo.setDeviceName(inte);
        });
        return this;
    }


}
