package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.database.TaskDto;
import com.mmc.tmj.utils.builder.statement.TaskDoStatementTmBuilder;
import java.util.Optional;
import org.apache.poi.ss.formula.functions.T;

/**
 * @Author lcz
 * @Date 2022/5/9 10:19
 * @Version 1.0
 * @description
 */
public class TaskDoTmBuilder extends TaskDoStatementTmBuilder<TaskDto> {

    public static TaskDoTmBuilder getInstance(){
        return new TaskDoTmBuilder();
    }

    @Override
    public TaskDto getObject() {
        return taskDto;
    }

    @Override
    public TaskDoTmBuilder init(TaskDto object) {
        this.taskDto=object;
        return this;
    }

    @Override
    public TaskDoTmBuilder init() {
        this.taskDto=new TaskDto();
        return this;
    }

    @Override
    public TaskDoTmBuilder buildId(Integer id) {
        Optional.ofNullable(id).ifPresent(inte ->{
            this.taskDto.setId(inte);
        });
        return this;
    }

    @Override
    public TaskDoTmBuilder buildTaskName(String taskName) {
        Optional.ofNullable(taskName).ifPresent(inte ->{
            this.taskDto.setTaskName(inte);
        });
        return this;
    }

    @Override
    public TaskDoTmBuilder buildRouteName(String routeName) {
        Optional.ofNullable(routeName).ifPresent(inte ->{
            this.taskDto.setRouteName(inte);
        });
        return this;
    }

    @Override
    public TaskDoTmBuilder buildOrganizationName(String organizationName) {
        Optional.ofNullable(organizationName).ifPresent(inte ->{
            this.taskDto.setOrganizationName(inte);
        });
        return this;
    }

    @Override
    public TaskDoTmBuilder buildDeviceId(Integer deviceId) {
        Optional.ofNullable(deviceId).ifPresent(inte ->{
            this.taskDto.setDeviceId(inte);
        });
        return this;
    }

    @Override
    public TaskDoTmBuilder buildDeviceName(String deviceName) {
        Optional.ofNullable(deviceName).ifPresent(inte ->{
            this.taskDto.setDeviceName(inte);
        });
        return this;
    }

    @Override
    public TaskDoTmBuilder buildDeviceHardId(String deviceHardId) {
        Optional.ofNullable(deviceHardId).ifPresent(inte ->{
            this.taskDto.setDeviceHardId(inte);
        });
        return this;
    }

    @Override
    public TaskDoTmBuilder buildRemark(String remark) {
        Optional.ofNullable(remark).ifPresent(inte ->{
            this.taskDto.setRemark(inte);
        });
        return this;
    }

    @Override
    public TaskDoTmBuilder buildDeviceStatus(Integer deviceStatus) {
        Optional.ofNullable(deviceStatus).ifPresent(inte ->{
            this.taskDto.setDeviceStatus(inte);
        });
        return this;
    }

    @Override
    public TaskDoTmBuilder buildTaskStatus(Integer taskStatus) {
        Optional.ofNullable(taskStatus).ifPresent(inte ->{
            this.taskDto.setTaskStatus(inte);
        });
        return this;
    }

    @Override
    public TaskDoTmBuilder buildAddTime(String addTime) {
        Optional.ofNullable(addTime).ifPresent(inte ->{
            this.taskDto.setAddTime(inte);
        });
        return this;
    }

    @Override
    public TaskDoTmBuilder buildStartTime(String startTime) {
        Optional.ofNullable(startTime).ifPresent(inte ->{
            this.taskDto.setStartTime(inte);
        });
        return this;
    }

    @Override
    public TaskDoTmBuilder buildEndTime(String endTime) {
        Optional.ofNullable(endTime).ifPresent(inte ->{
            this.taskDto.setEndTime(inte);
        });
        return this;
    }
}
