package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.database.RouteDo;
import com.mmc.tmj.entity.database.RoutePointDo;
import com.mmc.tmj.entity.other.RouteUploadDto;
import com.mmc.tmj.entity.other.RouteUploadDto.RoutePointUploadDto;
import com.mmc.tmj.utils.builder.statement.RouteDoStatementTmBuilder;
import com.mmc.tmj.utils.builder.statement.RouteUploadDtoStatementTmBuilder;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/16 10:52
 * @Version 1.0
 * @description
 */
public class RouteUploadDtoTmBuilder extends RouteUploadDtoStatementTmBuilder<RouteUploadDto> {
    public static RouteUploadDtoTmBuilder getInstance(){
        return new RouteUploadDtoTmBuilder();
    }
    @Override
    public RouteUploadDto getObject() {
        return routeUploadDto;
    }

    @Override
    public RouteUploadDtoTmBuilder init(RouteUploadDto object) {
        this.routeUploadDto=object;
        return this;
    }

    @Override
    public RouteUploadDtoTmBuilder init() {
        this.routeUploadDto=new RouteUploadDto();
        return this;
    }


    @Override
    public RouteUploadDtoTmBuilder buildName(String name) {
        Optional.ofNullable(name).ifPresent(inte ->{
            this.routeUploadDto.setName(inte);
        });
        return this;
    }

    @Override
    public RouteUploadDtoTmBuilder buildDefaultAltitude(Double defaultAltitude) {
        this.routeUploadDto.setDefaultAltitude(Optional.ofNullable(defaultAltitude).orElse(100.0));
        return this;
    }

    @Override
    public RouteUploadDtoTmBuilder buildDefaultSpeed(Double defaultSpeed) {
        this.routeUploadDto.setDefaultSpeed(Optional.ofNullable(defaultSpeed).orElse(3.0));
        return this;
    }

    @Override
    public RouteUploadDtoTmBuilder buildDefaultYawAngle(Double defaultYawAngle) {
        this.routeUploadDto.setDefaultYawAngle(Optional.ofNullable(defaultYawAngle).orElse(0.0));
        return this;
    }

    @Override
    public RouteUploadDtoTmBuilder buildDefaultPitchAngle(Double defaultPitchAngle) {
        this.routeUploadDto.setDefaultPitchAngle(Optional.ofNullable(defaultPitchAngle).orElse(0.0));
        return this;
    }

    @Override
    public RouteUploadDtoTmBuilder buildPoints(List<RoutePointUploadDto> points) {
        this.routeUploadDto.setPoints(points);
        return this;
    }


    @Override
    public RouteUploadDtoTmBuilder buildRemark(String remark) {
        Optional.ofNullable(remark).ifPresent(inte ->{
            this.routeUploadDto.setRemark(inte);
        });
        return this;
    }
}
