package com.mmc.tmj.utils.builder.statement.impl;



import com.mmc.tmj.entity.other.RouteUploadDto.ActionUploadDto;
import com.mmc.tmj.entity.other.RouteUploadDto.RoutePointUploadDto;
import com.mmc.tmj.utils.builder.statement.RoutePointUploadDtoStatementTmBuilder;
import java.util.List;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/16 11:25
 * @Version 1.0
 * @description
 */
public class RoutePointUploadDtoTmBuilder extends RoutePointUploadDtoStatementTmBuilder<RoutePointUploadDto> {
    public static RoutePointUploadDtoTmBuilder getInstance(){
        return new RoutePointUploadDtoTmBuilder();
    }
    @Override
    public RoutePointUploadDto getObject() {
        return routePointUploadDto;
    }

    @Override
    public RoutePointUploadDtoTmBuilder init(RoutePointUploadDto object) {
        routePointUploadDto=object;
        return this;
    }

    @Override
    public RoutePointUploadDtoTmBuilder init() {
        routePointUploadDto=new RoutePointUploadDto();
        return this;
    }

    @Override
    public RoutePointUploadDtoTmBuilder buildName(String name) {
        Optional.ofNullable(name).ifPresent(inte ->{
            this.routePointUploadDto.setName(inte);
        });
        return this;
    }

    @Override
    public RoutePointUploadDtoTmBuilder buildUuid(String uuid) {
        Optional.ofNullable(uuid).ifPresent(inte ->{
            this.routePointUploadDto.setUuid(inte);
        });
        return this;
    }

    @Override
    public RoutePointUploadDtoTmBuilder buildLatitude(Double latitude) {
        this.routePointUploadDto.setLatitude(Optional.ofNullable(latitude).orElse(0.0));
        return this;
    }

    @Override
    public RoutePointUploadDtoTmBuilder buildLongitude(Double longitude) {
        this.routePointUploadDto.setLongitude(Optional.ofNullable(longitude).orElse(0.0));
        return this;
    }

    @Override
    public RoutePointUploadDtoTmBuilder buildAltitude(Double altitude) {
        this.routePointUploadDto.setAltitude(Optional.ofNullable(altitude).orElse(100.0));
        return this;
    }

    @Override
    public RoutePointUploadDtoTmBuilder buildYawAngle(Double yawAngle) {
        this.routePointUploadDto.setYawAngle(Optional.ofNullable(yawAngle).orElse(0.0));
        return this;
    }

    @Override
    public RoutePointUploadDtoTmBuilder buildPitchAngle(Double pitchAngle) {
        this.routePointUploadDto.setPitchAngle(Optional.ofNullable(pitchAngle).orElse(0.0));
        return this;
    }

    @Override
    public RoutePointUploadDtoTmBuilder buildSpeed(Double speed) {
        this.routePointUploadDto.setSpeed(Optional.ofNullable(speed).orElse(3.0));
        return this;
    }

    @Override
    public RoutePointUploadDtoTmBuilder buildActions(List<ActionUploadDto> actions) {
        this.routePointUploadDto.setActions(actions);
        return this;
    }
}
