package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.result.ActionDetail;
import com.mmc.tmj.entity.result.RoutePointDetail;
import com.mmc.tmj.utils.builder.statement.RoutePointDetailStatementTmBuilder;
import java.util.List;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/16 11:25
 * @Version 1.0
 * @description
 */
public class RoutePointDetailTmBuilder extends RoutePointDetailStatementTmBuilder<RoutePointDetail> {
    public static RoutePointDetailTmBuilder getInstance(){
        return new RoutePointDetailTmBuilder();
    }
    @Override
    public RoutePointDetail getObject() {
        return routePointDetail;
    }

    @Override
    public RoutePointDetailTmBuilder init(RoutePointDetail object) {
        routePointDetail=object;
        return this;
    }

    @Override
    public RoutePointDetailTmBuilder init() {
        routePointDetail=new RoutePointDetail();
        return this;
    }


    @Override
    public RoutePointDetailTmBuilder buildUuid(String uuid) {
        Optional.ofNullable(uuid).ifPresent(inte ->{
            this.routePointDetail.setUuid(inte);
        });
        return this;
    }

    @Override
    public RoutePointDetailTmBuilder buildLatitude(Double latitude) {
        this.routePointDetail.setLatitude(Optional.ofNullable(latitude).orElse(0.0));
        return this;
    }

    @Override
    public RoutePointDetailTmBuilder buildLongitude(Double longitude) {
        this.routePointDetail.setLongitude(Optional.ofNullable(longitude).orElse(0.0));
        return this;
    }

    @Override
    public RoutePointDetailTmBuilder buildAltitude(Double altitude) {
        this.routePointDetail.setAltitude(Optional.ofNullable(altitude).orElse(100.0));
        return this;
    }

    @Override
    public RoutePointDetailTmBuilder buildYawAngle(Double yawAngle) {
        this.routePointDetail.setYawAngle(Optional.ofNullable(yawAngle).orElse(0.0));
        return this;
    }

    @Override
    public RoutePointDetailTmBuilder buildPitchAngle(Double pitchAngle) {
        this.routePointDetail.setPitchAngle(Optional.ofNullable(pitchAngle).orElse(0.0));
        return this;
    }

    @Override
    public RoutePointDetailTmBuilder buildSpeed(Double speed) {
        this.routePointDetail.setSpeed(Optional.ofNullable(speed).orElse(3.0));
        return this;
    }

    @Override
    public RoutePointDetailTmBuilder buildActions(List<ActionDetail> actions) {
        this.routePointDetail.setActions(actions);
        return this;
    }
}
