package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.result.RouteDetail;
import com.mmc.tmj.entity.result.RoutePointDetail;
import com.mmc.tmj.utils.builder.statement.RouteDetailStatementTmBuilder;
import java.util.List;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/17 10:18
 * @Version 1.0
 * @description
 */
public class RouteDetailTmBuilder extends RouteDetailStatementTmBuilder<RouteDetail> {
    public static RouteDetailTmBuilder getInstance(){
        return new RouteDetailTmBuilder();
    }
    @Override
    public RouteDetail getObject() {
        return routeDetail;
    }

    @Override
    public RouteDetailTmBuilder init(RouteDetail object) {
        routeDetail=object;
        return this;
    }

    @Override
    public RouteDetailTmBuilder init() {
        routeDetail = new RouteDetail();
        return this;
    }

    @Override
    public RouteDetailTmBuilder buildId(Integer id) {
        Optional.ofNullable(id).ifPresent(inte ->{
            this.routeDetail.setId(inte);
        });
        return this;
    }

    @Override
    public RouteDetailTmBuilder buildName(String name) {
        Optional.ofNullable(name).ifPresent(inte ->{
            this.routeDetail.setName(inte);
        });
        return this;
    }

    @Override
    public RouteDetailTmBuilder buildPoints(List<RoutePointDetail> points) {
        Optional.ofNullable(points).ifPresent(inte ->{
            this.routeDetail.setPoints(inte);
        });
        return this;
    }
}
