package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.result.PageRespVo;
import com.mmc.tmj.utils.builder.statement.PageRespVoStatementTmBuilder;
import com.mmc.tmj.utils.builder.statement.TaskDoStatementTmBuilder;
import java.util.List;
import java.util.Optional;
import org.apache.poi.ss.formula.functions.T;

/**
 * @Author lcz
 * @Date 2022/5/12 11:56
 * @Version 1.0
 * @description
 */
public class PageRespVoTmBuilder extends PageRespVoStatementTmBuilder<PageRespVo<T>> {

    public static PageRespVoTmBuilder getInstance(){
        return new PageRespVoTmBuilder();
    }

    @Override
    public PageRespVo getObject() {
        return this.pageRespVo;
    }

    @Override
    public PageRespVoTmBuilder buildTotalSize(Long totalSize) {
        Optional.ofNullable(totalSize).ifPresent(in->{
            this.pageRespVo.setTotalSize(in);
        });
        return this;
    }

    @Override
    public PageRespVoTmBuilder buildTotalNum(Integer totalNum) {
        Optional.ofNullable(totalNum).ifPresent(in->{
            this.pageRespVo.setTotalNum(in);
        });
        return this;
    }

    @Override
    public PageRespVoTmBuilder buildNum(Integer num) {
        Optional.ofNullable(num).ifPresent(in->{
            this.pageRespVo.setNum(in);
        });
        return this;
    }

    @Override
    public PageRespVoTmBuilder buildSize(Integer size) {
        Optional.ofNullable(size).ifPresent(in->{
            this.pageRespVo.setSize(in);
        });
        return this;
    }

    @Override
    public PageRespVoStatementTmBuilder buildData(List<PageRespVo<T>> data) {
        Optional.ofNullable(data).ifPresent(in->{
            this.pageRespVo.setData(in);
        });
        return this;
    }

}
