package com.mmc.tmj.utils.builder.statement.impl;

import cn.afterturn.easypoi.entity.ImageEntity;
import com.mmc.tmj.utils.builder.statement.ImageEntityStatementTmBuilder;

/**
 * @Author lcz
 * @Date 2022/5/18 16:03
 * @Version 1.0
 * @description
 */
public class ImageEntityTmBuilder extends ImageEntityStatementTmBuilder<ImageEntity> {
    public static ImageEntityTmBuilder getInstance(){
        return new ImageEntityTmBuilder();
    }
    @Override
    public ImageEntity getObject() {
        return imageEntity;
    }

    @Override
    public ImageEntityTmBuilder init(ImageEntity object) {
        imageEntity = object;
        return this;
    }

    @Override
    public ImageEntityTmBuilder init() {
        imageEntity = new ImageEntity();
        return this;
    }

    @Override
    public ImageEntityTmBuilder buildHeight(int height) {
        imageEntity.setHeight(height);
        return this;
    }

    @Override
    public ImageEntityTmBuilder buildWidth(int width) {
        imageEntity.setWidth(width);
        return this;
    }

    @Override
    public ImageEntityTmBuilder buildUrl(String url) {
        imageEntity.setUrl(url);
        return this;
    }

    @Override
    public ImageEntityTmBuilder buildType(String type) {
        imageEntity.setType(type);
        return this;
    }
}
