package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.database.ActionDo;
import com.mmc.tmj.entity.database.GISMapDo;
import com.mmc.tmj.entity.database.RoutePointDo;
import com.mmc.tmj.utils.builder.statement.GisMapDoStatementTmBuilder;
import com.mmc.tmj.utils.builder.statement.RoutePointDoStatementTmBuilder;
import java.util.List;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/16 11:25
 * @Version 1.0
 * @description
 */
public class GisMapDoTmBuilder extends GisMapDoStatementTmBuilder<GISMapDo> {
    public static GisMapDoTmBuilder getInstance(){
        return new GisMapDoTmBuilder();
    }
    @Override
    public GISMapDo getObject() {
        return gisMapDo;
    }

    @Override
    public GisMapDoTmBuilder init(GISMapDo object) {
        gisMapDo=object;
        return this;
    }

    @Override
    public GisMapDoTmBuilder init() {
        gisMapDo=new GISMapDo();
        return this;
    }

    @Override
    public GisMapDoTmBuilder buildId(Integer id) {
        Optional.ofNullable(id).ifPresent(inte ->{
            this.gisMapDo.setId(inte);
        });
        return this;
    }

    @Override
    public GisMapDoTmBuilder buildName(String name) {
        Optional.ofNullable(name).ifPresent(inte ->{
            this.gisMapDo.setName(inte);
        });
        return this;
    }

    @Override
    public GisMapDoTmBuilder buildLatitude(double latitude) {
        Optional.ofNullable(latitude).ifPresent(inte ->{
            this.gisMapDo.setLatitude(inte);
        });
        return this;
    }

    @Override
    public GisMapDoTmBuilder buildLongitude(double longitude) {
        Optional.ofNullable(longitude).ifPresent(inte ->{
            this.gisMapDo.setLongitude(inte);
        });
        return this;
    }

    @Override
    public GisMapDoTmBuilder buildAddress(String address) {
        Optional.ofNullable(address).ifPresent(inte ->{
            this.gisMapDo.setAddress(inte);
        });
        return this;
    }

    @Override
    public GisMapDoTmBuilder buildUnit(String unit) {
        Optional.ofNullable(unit).ifPresent(inte ->{
            this.gisMapDo.setUnit(inte);
        });
        return this;
    }




}
