package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.result.DeviceSelectDto;
import com.mmc.tmj.utils.builder.statement.DeviceSelectDtoStatementTmBuilder;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/17 16:48
 * @Version 1.0
 * @description
 */
public class DeviceSelectDtoTmBuilder extends DeviceSelectDtoStatementTmBuilder<DeviceSelectDto> {
    public static DeviceSelectDtoTmBuilder getInstance(){
        return new DeviceSelectDtoTmBuilder();
    }
    @Override
    public DeviceSelectDto getObject() {
        return deviceSelectDto;
    }

    @Override
    public DeviceSelectDtoTmBuilder init(DeviceSelectDto object) {
        deviceSelectDto = object;
        return this;
    }

    @Override
    public DeviceSelectDtoTmBuilder init() {
        deviceSelectDto = new DeviceSelectDto();
        return this;
    }

    @Override
    public DeviceSelectDtoTmBuilder buildDevice_id(Integer device_id) {
        Optional.ofNullable(device_id).ifPresent(inte ->{
            this.deviceSelectDto.setDevice_id(inte);
        });
        return this;
    }

    @Override
    public DeviceSelectDtoTmBuilder buildDeviceName(String deviceName) {
        Optional.ofNullable(deviceName).ifPresent(inte ->{
            this.deviceSelectDto.setDeviceName(inte);
        });
        return this;
    }

    @Override
    public DeviceSelectDtoTmBuilder buildSocketStatus(Integer socketStatus) {
        Optional.ofNullable(socketStatus).ifPresent(inte ->{
            this.deviceSelectDto.setSocketStatus(inte);
        });
        return this;
    }

    @Override
    public DeviceSelectDtoTmBuilder buildDeviceSerial(String deviceSerial) {
        Optional.ofNullable(deviceSerial).ifPresent(inte ->{
            this.deviceSelectDto.setDeviceSerial(inte);
        });
        return this;
    }

    @Override
    public DeviceSelectDtoTmBuilder buildDeviceHardId(String deviceHardId) {
        Optional.ofNullable(deviceHardId).ifPresent(inte ->{
            this.deviceSelectDto.setDeviceHardId(inte);
        });
        return this;
    }

    @Override
    public DeviceSelectDtoTmBuilder buildDeviceHashId(String deviceHashId) {
        Optional.ofNullable(deviceHashId).ifPresent(inte ->{
            this.deviceSelectDto.setDeviceHashId(inte);
        });
        return this;
    }
}
