package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.database.ActionDo;
import com.mmc.tmj.enums.ActionType;
import com.mmc.tmj.utils.builder.statement.ActionDoStatementTmBuilder;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/16 11:42
 * @Version 1.0
 * @description
 */
public class ActionDoTmBuilder extends ActionDoStatementTmBuilder<ActionDo> {
    public static ActionDoTmBuilder getInstance(){
        return new ActionDoTmBuilder();
    }
    @Override
    public ActionDo getObject() {
        return actionDo;
    }

    @Override
    public ActionDoTmBuilder init(ActionDo object) {
        actionDo = object;
        return this;
    }

    @Override
    public ActionDoTmBuilder init() {
        actionDo = new ActionDo();
        return this;
    }

    @Override
    public ActionDoTmBuilder buildId(Integer id) {
        Optional.ofNullable(id).ifPresent(inte ->{
            this.actionDo.setId(inte);
        });
        return this;
    }

    @Override
    public ActionDoTmBuilder buildActionType(ActionType actionType) {
        Optional.ofNullable(actionType).ifPresent(inte ->{
            this.actionDo.setType(inte);
        });
        return this;
    }

    @Override
    public ActionDoTmBuilder buildTakeSecond(Integer takeSecond) {
        this.actionDo.setTakeSecond(Optional.ofNullable(takeSecond).orElse(0));
        return this;
    }
}
