package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.database.ActionDo;
import com.mmc.tmj.entity.result.ActionDetail;
import com.mmc.tmj.enums.ActionType;
import com.mmc.tmj.utils.builder.statement.ActionDetailStatementTmBuilder;
import com.mmc.tmj.utils.builder.statement.ActionDoStatementTmBuilder;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/16 11:42
 * @Version 1.0
 * @description
 */
public class ActionDetailTmBuilder extends ActionDetailStatementTmBuilder<ActionDetail> {
    public static ActionDetailTmBuilder getInstance(){
        return new ActionDetailTmBuilder();
    }
    @Override
    public ActionDetail getObject() {
        return actionDetail;
    }

    @Override
    public ActionDetailTmBuilder init(ActionDetail object) {
        actionDetail = object;
        return this;
    }

    @Override
    public ActionDetailTmBuilder init() {
        actionDetail = new ActionDetail();
        return this;
    }


    @Override
    public ActionDetailTmBuilder buildType(ActionType actionType) {
        Optional.ofNullable(actionType).ifPresent(inte ->{
            this.actionDetail.setType(inte);
        });
        return this;
    }

    @Override
    public ActionDetailTmBuilder buildTakeSecond(Integer takeSecond) {
        this.actionDetail.setTakeSecond(Optional.ofNullable(takeSecond).orElse(0));
        return this;
    }
}
