package com.mmc.tmj.utils.builder.statement;

import com.mmc.tmj.entity.database.ActionDo;
import com.mmc.tmj.entity.database.RouteDo;
import com.mmc.tmj.entity.database.RoutePointDo;
import com.mmc.tmj.utils.builder.TmBuilder;
import java.time.LocalDateTime;
import java.util.List;


/**
 * @Author lcz
 * @Date 2022/5/9 10:16
 * @Version 1.0
 * @description
 */
public abstract class RoutePointDoStatementTmBuilder<T> extends TmBuilder<RoutePointDo> {
    protected RoutePointDo routePointDo = new RoutePointDo();

    @Override
    public abstract RoutePointDoStatementTmBuilder init(RoutePointDo object);

    @Override
    public abstract RoutePointDoStatementTmBuilder init();

    public abstract RoutePointDoStatementTmBuilder buildId(Integer id);

    public abstract RoutePointDoStatementTmBuilder buildUuid(String uuid);

    public abstract RoutePointDoStatementTmBuilder buildLatitude(Double latitude);

    public abstract RoutePointDoStatementTmBuilder buildLongitude(Double longitude);

    public abstract RoutePointDoStatementTmBuilder buildAltitude(Double altitude);

    public abstract RoutePointDoStatementTmBuilder buildYawAngle(Double yawAngle);

    public abstract RoutePointDoStatementTmBuilder buildPitchAngle(Double pitchAngle);

    public abstract RoutePointDoStatementTmBuilder buildSpeed(Double speed);

    public abstract RoutePointDoStatementTmBuilder buildActions(List<ActionDo> actions);


}
