package com.mmc.tmj.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.data.domain.Sort.Order;

/**
 * @Author lcz
 * @Date 2022/5/17 10:51
 * @Version 1.0
 * @description
 */
public class SortUtils {

    public static List<Order> ordersOfSort(String sort) {
        if(ObjectUtils.isEmpty(sort)){
            return Arrays.asList(Order.by("id"));
        }
        List<Order> orders = new ArrayList<>();
        String[] split = sort.split(",");
        for(String sp:split){
            orders.add(order(sp));
        }
        return orders;
    }

    private static Order order(String orderOfStr) {
        Direction dir = Direction.ASC;
        String proper = orderOfStr;
        if(hasPlusOrMinusSymbol(orderOfStr)){
            proper=orderOfStr.substring(1);
        }
        if(orderOfStr.startsWith("-")){
            dir=Direction.DESC;
        }
        return new Order(dir,proper);
    }

    private static boolean hasPlusOrMinusSymbol(String orderOfStr) {

        if(ObjectUtils.isEmpty(orderOfStr)){
            return false;
        }
        if(orderOfStr.startsWith("-") || orderOfStr.startsWith("+") ){
            return true;
        }
        return false;
    }
}
