package com.mmc.tmj.utils;

import cn.afterturn.easypoi.entity.ImageEntity;
import com.alibaba.fastjson.JSONObject;
import com.mmc.tmj.entity.database.ActionDo;
import com.mmc.tmj.entity.database.GISMapDo;
import com.mmc.tmj.entity.database.PhotographDo;
import com.mmc.tmj.entity.database.RouteDo;
import com.mmc.tmj.entity.database.RoutePointDo;
import com.mmc.tmj.entity.database.RunProjectDo;
import com.mmc.tmj.entity.database.TaskDto;
import com.mmc.tmj.entity.database.TrackDo;
import com.mmc.tmj.entity.other.ActionFormat;
import com.mmc.tmj.entity.other.PointFormat;
import com.mmc.tmj.entity.other.RouteFormat;
import com.mmc.tmj.entity.other.RouteUploadDto;
import com.mmc.tmj.entity.other.RouteUploadDto.ActionUploadDto;
import com.mmc.tmj.entity.other.RouteUploadDto.RoutePointUploadDto;
import com.mmc.tmj.entity.other.RunProjectDto;
import com.mmc.tmj.entity.other.RunProjectListDto;
import com.mmc.tmj.entity.other.SpeedDistanceTuple;
import com.mmc.tmj.entity.param.ActionWebDto;
import com.mmc.tmj.entity.param.GISMapWebDto;
import com.mmc.tmj.entity.param.RouteDataDto;
import com.mmc.tmj.entity.param.RoutePointDataDto;
import com.mmc.tmj.entity.param.RunProjectWebDto;
import com.mmc.tmj.entity.param.TaskWebDto;
import com.mmc.tmj.entity.param.TrackWebDto;
import com.mmc.tmj.entity.response.ExhibitionPointListMapVo;
import com.mmc.tmj.entity.response.FlyBaseInfo;
import com.mmc.tmj.entity.response.FlyHealthStatuInfo;
import com.mmc.tmj.entity.response.FlyListMapVo;
import com.mmc.tmj.entity.response.FlyManListMapVo;
import com.mmc.tmj.entity.response.ServicePointListMapVo;
import com.mmc.tmj.entity.response.TrainPointListMapVo;
import com.mmc.tmj.entity.result.ActionDetail;
import com.mmc.tmj.entity.result.DeviceSelectDto;
import com.mmc.tmj.entity.result.PhotographListVo;
import com.mmc.tmj.entity.result.RouteDetail;
import com.mmc.tmj.entity.result.RouteList;
import com.mmc.tmj.entity.result.RoutePointDetail;
import com.mmc.tmj.entity.result.TaskInfoVo;
import com.mmc.tmj.entity.result.TaskListVo;
import com.mmc.tmj.entity.result.TaskReportDto;
import com.mmc.tmj.entity.result.TaskSelectVo;
import com.mmc.tmj.utils.builder.statement.impl.ActionDetailTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.ActionDoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.ActionUploadDtoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.DeviceSelectDtoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.GisMapDoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.ImageEntityTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.PhotographDoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.PhotographListVoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.RouteDetailTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.RouteDoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.RouteListTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.RoutePointDetailTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.RoutePointDoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.RoutePointUploadDtoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.RouteUploadDtoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.RunProjectDoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.TaskDoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.TaskInfoVoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.TaskListVoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.TaskReportDtoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.TaskReportMapTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.TaskSelectVoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.TrackDoTmBuilder;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

/**
 * @Author lcz
 * @Date 2022/5/14 10:03
 * @Version 1.0
 * @description
 */
public class BeanTransFormUtil {

    public static TaskListVo transTaskListVo(TaskDto taskDto){
        return TaskListVoTmBuilder.getInstance()
            .init()
            .buildId(taskDto.getId())
            .buildDeviceHardId(taskDto.getDeviceHardId())
            .buildCreateWhen(taskDto.getAddTime())
            .buildDeviceName(taskDto.getDeviceName())
            .buildTaskName(taskDto.getTaskName())
            .buildTaskStatus(taskDto.getTaskStatus())
            .buildOrganizationName(taskDto.getOrganizationName())
            .buildDeviceId(taskDto.getDeviceId())
            .buildDeviceStatus(taskDto.getDeviceStatus())
            .buildRouteName(taskDto.getRouteName())
            .getObject();
    }

    public static TaskSelectVo transTaskSelectVo(TaskDto taskDto){
        return TaskSelectVoTmBuilder.getInstance()
            .init()
            .buildId(taskDto.getId())
            .buildTaskName(taskDto.getTaskName())
            .getObject();
    }
    public static TaskInfoVo transTaskInfoVo(TaskDto taskDto){
        return TaskInfoVoTmBuilder.getInstance()
            .init()
            .buildTaskName(taskDto.getTaskName())
            .buildDeviceName(taskDto.getDeviceName())
            .buildRouteName(taskDto.getRouteName())
            .getObject();
    }


    public static TaskDto transCreateTaskDto(TaskWebDto createDto){
        return TaskDoTmBuilder.getInstance()
            .init()
            .buildTaskName(createDto.getTaskName())
            .buildRouteName(createDto.getRouteName())
            .buildOrganizationName(createDto.getOrganizationName())
            .buildDeviceId(createDto.getDeviceId())
            .buildDeviceName(createDto.getDeviceName())
            .buildDeviceStatus(createDto.getDeviceStatus())
            .buildRemark(createDto.getRemark())
            .buildDeviceHardId(createDto.getDeviceHardId())
            .buildTaskStatus(1)
            .buildAddTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()))
            .getObject();
    }

    public static TaskDto transUpdateTaskDto(TaskDto taskDto,TaskWebDto createDto){
        return TaskDoTmBuilder.getInstance()
            .init(taskDto)
            .buildId(createDto.getId())
            .buildTaskName(createDto.getTaskName())
            .buildRouteName(createDto.getRouteName())
            .buildOrganizationName(createDto.getOrganizationName())
            .buildDeviceId(createDto.getDeviceId())
            .buildDeviceName(createDto.getDeviceName())
            .buildRemark(createDto.getRemark())
            .buildDeviceHardId(createDto.getDeviceHardId())
            .getObject();
    }

    public static PhotographDo transPhotographDo(Integer taskId,String deviceHardId,String image){
        return PhotographDoTmBuilder.getInstance()
            .init()
            .buildDeviceHardId(deviceHardId)
            .buildImages(image)
            .buildTaskId(taskId)
            .buildCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()))
            .getObject();
    }

    public static PhotographListVo transPhotographListVo(PhotographDo photographDo){
        return PhotographListVoTmBuilder.getInstance()
            .init()
            .buildImages(photographDo.getImages())
            .buildCreateTime(photographDo.getCreateTime())
            .getObject();
    }

    public static RouteDo transRouteDo(RouteDataDto routeDataDto){
        return RouteDoTmBuilder.getInstance()
            .init()
            .buildDefaultAltitude(routeDataDto.getDefaultAltitude())
            .buildDefaultPitchAngle(routeDataDto.getDefaultPitchAngle())
            .buildDefaultSpeed(routeDataDto.getDefaultSpeed())
            .buildDefaultYawAngle(routeDataDto.getDefaultYawAngle())
            .buildName(routeDataDto.getName())
            .buildPoints(null!=routeDataDto.getPoints()?routeDataDto.getPoints().stream().map(BeanTransFormUtil::transRoutePointDo).collect(
                Collectors.toList()):null)
            .getObject();
    }
    public static RoutePointDo transRoutePointDo(RoutePointDataDto routePointDataDto){
        return RoutePointDoTmBuilder.getInstance()
            .init()
            .buildAltitude(routePointDataDto.getAltitude())
            .buildSpeed(routePointDataDto.getSpeed())
            .buildLatitude(routePointDataDto.getLatitude())
            .buildLongitude(routePointDataDto.getLongitude())
            .buildPitchAngle(routePointDataDto.getPitchAngle())
            .buildYawAngle(routePointDataDto.getYawAngle())
            .buildUuid(routePointDataDto.getUuid())
            .buildActions(routePointDataDto.getActions().stream().map(BeanTransFormUtil::transActionDo).collect(Collectors.toList()))
            .getObject();
    }

    public static ActionDo transActionDo(ActionWebDto actionWebDto){
        return ActionDoTmBuilder.getInstance()
            .init()
            .buildTakeSecond(actionWebDto.getTakeSecond())
            .buildActionType(actionWebDto.getType())
            .getObject();
    }

    public static RouteDo transUpdateRouteDo(RouteDo oldRouteDo, RouteDataDto routeDataDto) {
        return RouteDoTmBuilder.getInstance()
            .init(oldRouteDo)
            .buildDefaultAltitude(routeDataDto.getDefaultAltitude())
            .buildDefaultPitchAngle(routeDataDto.getDefaultPitchAngle())
            .buildDefaultSpeed(routeDataDto.getDefaultSpeed())
            .buildDefaultYawAngle(routeDataDto.getDefaultYawAngle())
            .buildName(routeDataDto.getName())
            .buildPoints(null!=routeDataDto.getPoints()?routeDataDto.getPoints().stream().map(BeanTransFormUtil::transRoutePointDo).collect(
                Collectors.toList()):null)
            .getObject();
    }

    public static RouteDo transRouteDoByUpload(String routeJson) {
        RouteFormat routeFormat = transRouteFormatByUploadJson(routeJson);
        RouteUploadDto routeUploadDto = transRouteUploadDtoByRouteFormat(routeFormat);
        return RouteDoTmBuilder.getInstance()
            .init()
            .buildDefaultAltitude(routeUploadDto.getDefaultAltitude())
            .buildDefaultPitchAngle(routeUploadDto.getDefaultPitchAngle())
            .buildDefaultSpeed(routeUploadDto.getDefaultSpeed())
            .buildDefaultYawAngle(routeUploadDto.getDefaultYawAngle())
            .buildName(routeUploadDto.getName())
            .buildPoints(null!=routeUploadDto.getPoints()?routeUploadDto.getPoints().stream().map(BeanTransFormUtil::transRoutePointDoByUpload).collect(
                Collectors.toList()):null)
            .buildRemark(routeUploadDto.getRemark())
            .getObject();
    }
    public static RoutePointDo transRoutePointDoByUpload(RoutePointUploadDto routePointUploadDto){
        return RoutePointDoTmBuilder.getInstance()
            .init()
            .buildAltitude(routePointUploadDto.getAltitude())
            .buildSpeed(routePointUploadDto.getSpeed())
            .buildLatitude(routePointUploadDto.getLatitude())
            .buildLongitude(routePointUploadDto.getLongitude())
            .buildPitchAngle(routePointUploadDto.getPitchAngle())
            .buildYawAngle(routePointUploadDto.getYawAngle())
            .buildUuid(routePointUploadDto.getUuid())
            .buildActions(routePointUploadDto.getActions().stream().map(BeanTransFormUtil::transActionDoByUpload).collect(Collectors.toList()))
            .getObject();
    }

    public static ActionDo transActionDoByUpload(ActionUploadDto actionUploadDto){
        return ActionDoTmBuilder.getInstance()
            .init()
            .buildTakeSecond(actionUploadDto.getTakeSecond())
            .buildActionType(actionUploadDto.getType())
            .getObject();
    }

    public static RouteFormat transRouteFormatByUploadJson(String routeJson){
        return JSONObject.parseObject(routeJson, RouteFormat.class);
    }

    public static RouteUploadDto transRouteUploadDtoByRouteFormat(RouteFormat routeFormat){
        return RouteUploadDtoTmBuilder.getInstance()
            .init()
            .buildDefaultAltitude(routeFormat.getLine().getBaseAltitude())
            .buildDefaultSpeed(routeFormat.getLine().getBaseSpeed())
            .buildDefaultPitchAngle(0.0)
            .buildDefaultYawAngle(0.0)
            .buildPoints(null!=routeFormat.getPoints()?routeFormat.getPoints().stream().map(BeanTransFormUtil::transRoutePointUploadDtoByPointFormat).collect(
                Collectors.toList()):null)
            .getObject();
    }

    public static RoutePointUploadDto transRoutePointUploadDtoByPointFormat(PointFormat pointFormat){
        return RoutePointUploadDtoTmBuilder.getInstance()
            .init()
            .buildName(pointFormat.getDescribe())
            .buildAltitude(pointFormat.getAlt())
            .buildSpeed(3.0)
            .buildLatitude(pointFormat.getLat())
            .buildLongitude(pointFormat.getLon())
            .buildPitchAngle(pointFormat.getGimbalPitch())
            .buildYawAngle(pointFormat.getPitch())
            .buildUuid(UUID.randomUUID().toString())
            .buildActions(pointFormat.getActions().stream().map(BeanTransFormUtil::transActionUploadDtoByActionFormat).collect(Collectors.toList()))
            .getObject();
    }

    public static ActionUploadDto transActionUploadDtoByActionFormat(ActionFormat actionFormat){
        return ActionUploadDtoTmBuilder.getInstance()
            .init()
            .buildTakeSecond(actionFormat.getActionParam())
            .buildActionType(actionFormat.getActionType())
            .getObject();
    }

    public static RouteDetail transRouteDetailByRouteDo(RouteDo routeDo){
        return RouteDetailTmBuilder.getInstance()
            .init()
            .buildId(routeDo.getId())
            .buildName(routeDo.getName())
            .buildPoints(routeDo.getPoints().stream().map(BeanTransFormUtil::transRoutePointDetailByRoutePointDo).collect(
                Collectors.toList()))
            .getObject();
    }

    public static RoutePointDetail transRoutePointDetailByRoutePointDo(RoutePointDo routePointDo){
        return RoutePointDetailTmBuilder.getInstance()
            .init()
            .buildAltitude(routePointDo.getAltitude())
            .buildLatitude(routePointDo.getLatitude())
            .buildSpeed(routePointDo.getSpeed())
            .buildLongitude(routePointDo.getLongitude())
            .buildPitchAngle(routePointDo.getPitchAngle())
            .buildYawAngle(routePointDo.getYawAngle())
            .buildUuid(routePointDo.getUuid())
            .buildActions(routePointDo.getActions().stream().map(BeanTransFormUtil::transActionDetailByActionDo).collect(Collectors.toList()))
            .getObject();
    }
    public static ActionDetail transActionDetailByActionDo(ActionDo actionDo){
        return ActionDetailTmBuilder.getInstance()
            .init()
            .buildTakeSecond(actionDo.getTakeSecond())
            .buildType(actionDo.getType())
            .getObject();
    }

    public static RouteList transRouteListByRouteDo(RouteDo routeDo){
        return RouteListTmBuilder.getInstance()
            .init()
            .buildCreateWhen(null!=routeDo.getCreateWhen() ? DateUtils.dateTimeString(routeDo.getCreateWhen(),"") : null)
            .buildDefaultAltitude(routeDo.getDefaultAltitude())
            .buildDefaultSpeed(routeDo.getDefaultSpeed())
            .buildName(routeDo.getName())
            .buildRemark(routeDo.getRemark())
            .buildExpectTakeMinute(expectTakeMinute(routeDo.getPoints()))
            .buildKmOfRoute(kmOfRoute(routeDo.getPoints()))
            .buildNumOfPoint(routeDo.getPoints().size())
            .buildId(routeDo.getId())
            .getObject();
    }



    public static GISMapDo transGISMapDoByGISMapWebDto(GISMapWebDto gisMapWebDto){
        return GisMapDoTmBuilder.getInstance()
            .init()
            .buildAddress(gisMapWebDto.getAddresss())
            .buildLatitude(gisMapWebDto.getLatitude())
            .buildLongitude(gisMapWebDto.getLongitude())
            .buildUnit(gisMapWebDto.getUnit())
            .buildName(gisMapWebDto.getName())
            .getObject();
    }

    public static DeviceSelectDto transDeviceSelectDtoByDataObj(Map<String, Object> map){
        return DeviceSelectDtoTmBuilder.getInstance()
            .init()
            .buildDevice_id((Integer)map.get("device_id"))
            .buildDeviceHardId((String) map.get("deviceHardId"))
            .buildDeviceHashId((String) map.get("deviceHashId"))
            .buildDeviceName((String) map.get("deviceName"))
            .buildDeviceSerial((String) map.get("deviceSerial"))
            .buildSocketStatus((Integer)map.get("socketStatus"))
            .getObject();
    }

    public static TrackDo transTrackDoByTrackWebDto(TrackWebDto trackWebDto){
        return TrackDoTmBuilder.getInstance()
            .init()
            .buildId(trackWebDto.getId())
            .getObject();
    }


    public static TaskReportDto transTaskReportDtoByTaskDto(TaskDto taskDto){
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return TaskReportDtoTmBuilder.getInstance()
            .init()
            .buildTaskId(taskDto.getId())
            .buildTaskName(taskDto.getTaskName())
            .buildTaskDate(LocalDateTime.parse(taskDto.getAddTime(),df))
            .buildStartTime(LocalDateTime.parse(taskDto.getStartTime(),df))
            .buildEndTime(LocalDateTime.parse(taskDto.getEndTime(),df))
            .buildRemark(taskDto.getRemark())
            .getObject();
    }

    public static Map<String,Object> transTaskReportMapByParam(TaskReportDto taskReportDto, String username,List<PhotographListVo> photograph){
        return TaskReportMapTmBuilder.getInstance()
            .init()
            .buildTaskId(taskReportDto.getTaskId())
            .buildTaskName(taskReportDto.getTaskName())
            .buildTaskDate(taskReportDto.getTaskDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")))
            .buildTaskTime((null!=photograph && photograph.size()>0) ? photograph.get(0).getCreateTime() : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()))
            .buildImageList((null!=photograph && photograph.size()>0) ? photograph.stream().map(BeanTransFormUtil::transImageEntityByPhotographListVo).collect(
                Collectors.toList()) : new ArrayList<>())
            .buildDeviceHardId(taskReportDto.getDeviceHardId())
            .buildExecutePerson(username)
            .buildReportAddTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()))
            .buildRemark(taskReportDto.getRemark())
            .getObject();
    }

    public static ImageEntity transImageEntityByPhotographListVo(PhotographListVo photographListVo){
        return ImageEntityTmBuilder.getInstance()
            .init()
            .buildHeight(170)
            .buildWidth(380)
            .buildType(ImageEntity.URL)
            .buildUrl(photographListVo.getImages())
            .getObject();
    }

    public static ImageEntity transImageEntityByPhotographListVoTest(String url){
        return ImageEntityTmBuilder.getInstance()
            .init()
            .buildHeight(170)
            .buildWidth(380)
            .buildType(ImageEntity.URL)
            .buildUrl(url)
            .getObject();
    }

    public static RunProjectDo transRunProjectDoByRunProjectWebDto(RunProjectWebDto runProjectWebDto){
        return RunProjectDoTmBuilder.getInstance()
            .init()
            .buildProjectName(runProjectWebDto.getProjectName())
            .buildProjectDescript(runProjectWebDto.getProjectDescript())
            .buildProjectAddress("深圳科比特")
            .buildLongitude(103.54682424)
            .buildLatitude(23.564865424)
            .getObject();
    }

    public static RunProjectListDto transRunProjectListDtoByRunProjectDo(RunProjectDo runProjectDo,Integer id){
        return RunProjectListDto.builder()
            .projectName(runProjectDo.getProjectName())
            .order(id)
            .id(runProjectDo.getId())
            .build();
    }
    public static RunProjectDto transRunProjectDtoByRunProjectDo(RunProjectDo runProjectDo){
        return RunProjectDto.builder()
            .projectName(runProjectDo.getProjectName())
            .projectDescript(runProjectDo.getProjectDescript())
            .id(runProjectDo.getId())
            .build();
    }

    public static FlyListMapVo transFlyListMapVoByMap(Map map,String id,String name){
        return FlyListMapVo.builder()
            .latitude((Double) map.get("lat"))
            .longitude((Double) map.get("lon"))
            .id(Integer.parseInt(id))
            .order(Integer.parseInt(id))
            .flyInfo(transFlyBaseInfoByMap(map,name,Integer.parseInt(id)))
            .healthStatuInfo(transFlyHealthStatuInfoByRamdown())
            .build();
    }
    public static FlyBaseInfo transFlyBaseInfoByMap(Map map,String name,Integer id){
        return FlyBaseInfo.builder()
            .flyType((String) map.get("device_name"))
            .flyName(name)
            .id(id)
            .imageType(transSumalationImageTypeMap().get((String) map.get("device_name")))
            .flyModel("SN_"+UUID.randomUUID().toString())
            .flySeriaNum(UUID.randomUUID().toString())
            .onlineStatus("在线")
            .flyStatus("忙碌")
            .build();
    }
    public static FlyHealthStatuInfo transFlyHealthStatuInfoByRamdown(){
        return FlyHealthStatuInfo.builder()
            .accelerationStatus(1)
            .airborneComputerStatus(1)
            .angularVilocityStatus(2)
            .attitudeUnlockStatus(1)
            .barometerStatus(1)
            .compassStatus(3)
            .distanceDetectionStatus(1)
            .electricMachineryStatus(1)
            .electronicFence(1)
            .fixeHeightStatus(1)
            .gyroscopeStatus(1)
            .headingControlStatus(1)
            .horizontalPositionStatus(1)
            .laserPositiStatus(1)
            .loggingStatus(1)
            .obsAvoidanceStatus(2)
            .optailFlowStatus(1)
            .positiModelStatus(1)
            .powerStatus(1)
            .rdpStatus(3)
            .powerSupplyStatus(1)
            .remoteControlStatus(1)
            .residualAccelerationStatus(3)
            .residualCompassStatus(1)
            .residualGyroscopeStatus(3)
            .satelliteCommunication(1)
            .simulatedFlight(1)
            .takeOffDetectionStatus(3)
            .verticalPositionStatus(1)
            .build();
    }
    public static Map<String,Integer> transSumalationImageTypeMap(){
        Map<String,Integer> map = new HashMap<>();
        map.put("入云龙-001",3);
        map.put("玉麒麟",2);
        map.put("入云龙",3);
        map.put("插翅虎-M12",4);
        map.put("小旋风Ⅰ",5);
        map.put("插翅虎-M9",6);
        return map;
    }
    public static FlyManListMapVo transFlyManListMapVoByMap(Map map,String id){
        return FlyManListMapVo.builder()
            .id(Integer.parseInt(id))
            .latitude((Double) map.get("lat"))
            .longitude((Double) map.get("lon"))
            .name((String) map.get("account_name"))
            .phone((String) map.get("phone_num"))
            .order(Integer.parseInt(id))
            .build();
    }



    public static TrainPointListMapVo transTrainPointListMapVoByMap(Map map,String id){
        return TrainPointListMapVo.builder()
            .id(Integer.parseInt(id))
            .latitude(Double.parseDouble(map.get("lat")+""))
            .longitude(Double.parseDouble(map.get("lon")+""))
            .trainAddress((String) map.get("address"))
            .trainName((String) map.get("name"))
            .order(Integer.parseInt(id))
            .build();
    }

    public static ServicePointListMapVo transServicePointListMapVoByMap(Map map,String id){
        return ServicePointListMapVo.builder()
            .id(Integer.parseInt(id))
            .latitude(Double.parseDouble(map.get("lat")+""))
            .longitude(Double.parseDouble(map.get("lon")+""))
            .serviceAddress((String) map.get("address"))
            .serviceName((String) map.get("name"))
            .order(Integer.parseInt(id))
            .build();
    }


    public static ExhibitionPointListMapVo transExhibitionPointListMapVoByMap(Map map,String id){
        return ExhibitionPointListMapVo.builder()
            .id(Integer.parseInt(id))
            .latitude(Double.parseDouble(map.get("lat")+""))
            .longitude(Double.parseDouble(map.get("lon")+""))
            .exhibitionAddress((String) map.get("address"))
            .exhibitionName((String) map.get("name"))
            .order(Integer.parseInt(id))
            .build();
    }

    //预计时长（单位min）
    private static double expectTakeMinute(List<RoutePointDo> points) {
        //speedKmTuples(points);
        return speedKmTuples(points).stream().map(SpeedDistanceTuple::takeMinute).reduce(0.0, Double::sum);
    }

    //航线长度（单位km）
    private static double kmOfRoute(List<RoutePointDo> points) {
        return speedKmTuples(points).stream().map(SpeedDistanceTuple::getKm).reduce(0.0, Double::sum);
    }

    //获取
    private static List<SpeedDistanceTuple> speedKmTuples(List<RoutePointDo> points) {
        List<SpeedDistanceTuple> tuples = new ArrayList<>();
        for (int i = 0; i < points.size(); i++) {
            RoutePointDo point = points.get(i);

            RoutePointDo nextPoint = (i + 1) >= points.size() ? null : points.get(i + 1);
            if (nextPoint == null) {
                return tuples;
            }
            tuples.add(
                new SpeedDistanceTuple(
                    point.getSpeed(), kmBetween(point.getLatitude(), point.getLongitude(), nextPoint.getLatitude(), nextPoint.getLongitude())));
        }
        return tuples;
    }
    private static double kmBetween(double lat1, double lng1, double lat2, double lng2){
        return GpsUtils.getKmDistance(
            lat1, lng1, lat2, lng2);
    }

}
