package com.mmc.tmj.service.task.impl;

import com.mmc.tmj.entity.database.PhotographDo;
import com.mmc.tmj.entity.database.TaskDto;
import com.mmc.tmj.entity.param.TaskWebDto;
import com.mmc.tmj.entity.result.PageRespVo;
import com.mmc.tmj.entity.result.PhotographListVo;
import com.mmc.tmj.entity.result.TaskInfoVo;
import com.mmc.tmj.entity.result.TaskListVo;
import com.mmc.tmj.entity.result.TaskReportDto;
import com.mmc.tmj.entity.result.TaskSelectVo;
import com.mmc.tmj.mapper.PhotographDoRepository;
import com.mmc.tmj.mapper.TaskRepository;
import com.mmc.tmj.service.photo.PhotographService;
import com.mmc.tmj.service.task.TaskService;
import com.mmc.tmj.service.task.assembler.TaskDoAssembler;
import com.mmc.tmj.utils.BeanTransFormUtil;
import com.mmc.tmj.utils.TmjBeanPath;
import com.mmc.tmj.utils.builder.statement.impl.PageRespVoTmBuilder;
import com.mmc.tmj.utils.builder.statement.impl.TaskInfoVoTmBuilder;
import com.querydsl.core.BooleanBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.stereotype.Service;

/**
 * @Author lcz
 * @Date 2022/5/7 16:44
 * @Version 1.0
 * @description
 */
@Service
public class TaskServiceImpl implements TaskService {

    //专门干脏活累活的类
    @Resource
    private TaskDoAssembler taskDoAssembler;

    @Resource
    private TaskRepository taskRepository;
    @Resource
    private PhotographDoRepository photographDoRepository;

    @Autowired
    private PhotographService photographService;

    @Override
    public boolean createTask(TaskWebDto createDto) {
        TaskDto taskDto = taskDoAssembler.fromTaskCreateDto(createDto);
        if(null != taskDto){
            taskRepository.save(taskDto);
            return true;
        }
        return false;
    }

    @Override
    public PageRespVo<TaskListVo> getTaskList(String taskName, String status, int num, int size) {
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        Optional.ofNullable(taskName).filter(StringUtils::isNotEmpty).ifPresent(is->{
            booleanBuilder.and(TmjBeanPath.of(TaskDto.class,"taskDto").createString("taskName").like("%"+is+"%"));
        });
        Optional.ofNullable(status).filter(StringUtils::isNotEmpty).ifPresent(is->{
            booleanBuilder.and(TmjBeanPath.of(TaskDto.class,"taskDto").createNumber("taskStatus",Integer.class).eq(Integer.parseInt(is)));
        });
        Page<TaskDto> pages=null;
        if(null==booleanBuilder.getValue()){
            pages=taskRepository.findAll(PageRequest.of(num-1, size, Direction.DESC, "id"));
        }else {
            pages=taskRepository.findAll(booleanBuilder.getValue(),PageRequest.of(num-1, size, Direction.DESC, "id"));
        }
        return (PageRespVo) PageRespVoTmBuilder.getInstance()
            .init()
            .buildNum(pages.getNumber() + 1)
            .buildSize(pages.getSize())
            .buildTotalNum(pages.getTotalPages())
            .buildData(0!=pages.getContent().size()?pages.getContent().stream().map(
                BeanTransFormUtil::transTaskListVo).collect(
                Collectors.toList()) : pages.getContent())
            .getObject();
    }

    @Override
    public List<TaskSelectVo> getTaskSelect(String name) {
        List<TaskDto> all = (List<TaskDto>) taskRepository.findAll(
            TmjBeanPath.of(TaskDto.class, "taskDto").createString("taskName")
                .like("%" + null != name ? name:"" + "%"));
        return all.stream().map(BeanTransFormUtil::transTaskSelectVo).collect(Collectors.toList());
    }

    @Override
    public boolean updateTask(TaskWebDto taskWebDto) {
        TaskDto taskDto = taskDoAssembler.fromTaskUpdateDto(taskWebDto);
        if(null != taskDto){
            taskRepository.save(taskDto);
            return true;
        }
        return false;
    }

    @Override
    public TaskInfoVo getTaskInfoById(Integer id) {
        Optional<TaskDto> byId = taskRepository.findById(id);
        if(!byId.isPresent()){
            throw new IllegalArgumentException("任务不存在");
        }
        return BeanTransFormUtil.transTaskInfoVo(byId.get());
    }

    @Override
    public boolean updateTaskStatus(Integer id,int oldStatus,int newStatus) {
        Optional<TaskDto> byId = taskRepository.findById(id);
        if(byId.isPresent() && !byId.get().getTaskStatus().equals(oldStatus)){
            return false;
        }
        TaskDto taskDto = byId.get();
        taskDto.setTaskStatus(newStatus);
        taskDto.setStartTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        taskRepository.save(taskDto);
        return true;
    }

    @Override
    public boolean deleteTask(Integer id) {
        if(null != taskRepository.findByIdAndTaskStatus(id,1)){
            taskRepository.deleteById(id);
            return true;
        }
        return false;
    }

    @Override
    public void savePhotograph(PhotographDo photographDo) {
        photographDoRepository.save(photographDo);
    }

    @Override
    public Integer checkTaskStatus(Integer taskId) {
        return taskRepository.checkTaskStatus(taskId);
    }

    @Override
    public TaskReportDto export(Integer taskId) {
        return BeanTransFormUtil.transTaskReportDtoByTaskDto(taskRepository.findById(taskId).get());
    }

    @Override
    public Map<String, Object> dataMap(TaskReportDto taskReportDto, String username) {
        List<PhotographListVo> photographByTaskId = photographService.getPhotographByTaskId(
            taskReportDto.getTaskId());
        return BeanTransFormUtil.transTaskReportMapByParam(taskReportDto,username,photographByTaskId);
    }

    @Override
    public void saveTaskReportInfo(Integer taskId, String uploadPath) {
        taskRepository.saveTaskReportInfo(taskId,uploadPath);
    }


}
