package com.mmc.tmj.service.task.assembler;

import com.mmc.tmj.entity.database.TaskDto;
import com.mmc.tmj.entity.param.TaskWebDto;
import com.mmc.tmj.mapper.TaskRepository;
import com.mmc.tmj.utils.BeanTransFormUtil;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

/**
 * @Author lcz
 * @Date 2022/5/9 9:59
 * @Version 1.0
 * @description
 */
@Component
public class TaskDoAssembler {

    @Resource
    private TaskRepository taskRepository;


    public TaskDto fromTaskCreateDto(TaskWebDto createDto) {
        TaskDto byTaskName = taskRepository.findByTaskName(createDto.getTaskName());
        if(null != byTaskName){
            return null;
        }
        return BeanTransFormUtil.transCreateTaskDto(createDto);
    }

    public TaskDto fromTaskUpdateDto(TaskWebDto taskWebDto) {
        if(null==taskWebDto.getId()){
            throw new IllegalArgumentException("缺失id");
        }
        TaskDto byTaskName = taskRepository.findByTaskName(taskWebDto.getTaskName());
        TaskDto taskDto = taskRepository.findById(taskWebDto.getId()).get();
        if(null != byTaskName && !taskDto.getId().equals(byTaskName.getId())){
            return null;
        }
        return BeanTransFormUtil.transUpdateTaskDto(taskDto,taskWebDto);
    }
}
