package com.mmc.tmj.service.runProject.impl;

import com.mmc.tmj.entity.database.RunProjectDo;
import com.mmc.tmj.entity.other.RunProjectDto;
import com.mmc.tmj.entity.other.RunProjectListDto;
import com.mmc.tmj.entity.param.RunProjectWebDto;
import com.mmc.tmj.mapper.RunProjectRepository;
import com.mmc.tmj.service.runProject.RunProjectService;
import com.mmc.tmj.utils.BeanTransFormUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Author lcz
 * @Date 2022/5/21 15:02
 * @Version 1.0
 * @description
 */
@Service
public class RunProjectServiceImpl implements RunProjectService {

    @Autowired
    private RunProjectRepository runProjectRepository;


    @Override
    public boolean createRunProject(RunProjectWebDto runProjectWebDto) {
        if(null != runProjectRepository.findByProjectName(runProjectWebDto.getProjectName())){
            return false;
        }
        runProjectRepository.save(BeanTransFormUtil.transRunProjectDoByRunProjectWebDto(runProjectWebDto));
        return true;
    }

    @Override
    public List<RunProjectListDto> getRunProjectListSimple(Integer accountId, String projectName) {
        List<RunProjectDo> allByProjectNameLike = runProjectRepository.findAllByProjectNameLike(
            "%"+projectName+"%");
        final int[] i={0};
        return null!=allByProjectNameLike?allByProjectNameLike.stream().map(it->{
            i[0]=i[0]+1;
            return BeanTransFormUtil.transRunProjectListDtoByRunProjectDo(it,i[0]);}).collect(
            Collectors.toList()) : new ArrayList<>();
    }

    @Override
    public boolean delete(Integer accountId, Integer id) {
        Optional<RunProjectDo> byId = runProjectRepository.findById(id);
        if(null!=byId && byId.isPresent()){
            runProjectRepository.deleteById(id);
            return true;
        }
        return false;
    }

    @Override
    public RunProjectDto getRunProjectInfo(Integer accountId, Integer id) {
        Optional<RunProjectDo> byId = runProjectRepository.findById(id);
        if(null != byId && byId.isPresent()){
            return BeanTransFormUtil.transRunProjectDtoByRunProjectDo(byId.get());
        }
        return null;
    }
}
