package com.mmc.tmj.service.route.impl;

import com.mmc.tmj.entity.database.RouteDo;
import com.mmc.tmj.entity.database.TaskDto;
import com.mmc.tmj.entity.other.RouteUploadDto;
import com.mmc.tmj.entity.param.RouteDataDto;
import com.mmc.tmj.entity.result.RouteDetail;
import com.mmc.tmj.entity.result.RouteList;
import com.mmc.tmj.entity.result.SliceRespVo;
import com.mmc.tmj.mapper.RouteRepository;
import com.mmc.tmj.service.file.impl.MinioStoreageServiceImpl;
import com.mmc.tmj.service.route.RouteService;
import com.mmc.tmj.service.route.assembler.RouteAssembler;
import com.mmc.tmj.utils.BeanTransFormUtil;
import com.mmc.tmj.utils.FileUtils;
import com.mmc.tmj.utils.SortUtils;
import com.mmc.tmj.utils.TmjBeanPath;
import com.querydsl.core.BooleanBuilder;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Sort.Order;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/**
 * @Author lcz
 * @Date 2022/5/14 16:29
 * @Version 1.0
 * @description
 */
@Service
public class RouteServiceImpl implements RouteService {
    @Autowired
    private RouteAssembler routeAssembler;

    @Autowired
    private RouteRepository routeRepository;

    @Resource
    private MinioStoreageServiceImpl minioStoreageService;

    @Value("${com.chuck.uploadDir}")
    private String uploadDir;

    @Override
    public boolean planRoute(RouteDataDto routeDataDto) {
        //查重，转换database bean,
        RouteDo routeDo=routeAssembler.fromRouteDto(routeDataDto);
        if(null== routeDo){
            return false;
            //throw new IllegalArgumentException("创建航线时，名称重复");
        }
        //保存
        routeRepository.save(routeDo);
        return true;
    }

    @Override
    public boolean updateRoute(RouteDataDto routeDataDto) {
        //查重，转换database bean,
        RouteDo routeDo=routeAssembler.fromUpdateRouteDto(routeDataDto);
        if(null == routeDo){
            return false;
            //throw new IllegalArgumentException("创建航线时，名称重复");
        }
        //保存
        routeRepository.save(routeDo);
        return true;
    }

    @Override
    public void saveUploadRoute(MultipartFile file) {
        Path path = FileUtils.dateTimePath(uploadDir);
        String fileName = FileUtils.uuidFileName(file.getOriginalFilename());
        minioStoreageService.storeElseAndRename(file,path,fileName);
        Path routeRe=minioStoreageService.loadFromElse(path,fileName);
        String routeJson = FileUtils.jsonString(routeRe);
        RouteDo v=routeAssembler.fromRouteByUploadJson(routeJson);
        RouteDo byName = routeRepository.findByName(v.getName());
        if(null != byName){
            throw new IllegalArgumentException("上传航线时，名称重复");
        }
        routeRepository.save(v);
    }

    @Override
    public boolean deleteByid(int id) {
        Optional<RouteDo> byId = routeRepository.findById(id);
        Boolean aBoolean = byId.map(
                iu -> routeRepository.checkTaskStatusByRouteName(iu.getName()) > 0)
            .orElseThrow(() -> new IllegalArgumentException("不存在的航线id"));
        if(aBoolean.booleanValue()){
            return false;
        }
        routeRepository.deleteById(id);
        return true;
    }

    @Override
    public RouteDetail routeDetail(String name) {
        RouteDo byName = routeRepository.findByName(name);
        return BeanTransFormUtil.transRouteDetailByRouteDo(byName);
    }

    @Override
    public SliceRespVo<RouteList> pages(String name, int num, int size, String sort) {
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        Optional.ofNullable(name).filter(StringUtils::isNotEmpty).ifPresent(is->{
            booleanBuilder.and(
                TmjBeanPath.of(RouteDo.class,"routeDo").createString("name").like("%"+is+"%"));
        });
        Sort by = Sort.by(SortUtils.ordersOfSort(sort));
        PageRequest of = PageRequest.of(num - 1, size, by);
        Page<RouteDo> all = (null==booleanBuilder.getValue())? routeRepository.findAll(of) : routeRepository.findAll(booleanBuilder.getValue(), of);
        return new SliceRespVo<>(
            all.getNumber()+1,
            all.getSize(),
            all.getContent().stream()
            .map(BeanTransFormUtil::transRouteListByRouteDo).collect(
                Collectors.toList())
        );
    }
}
