package com.mmc.tmj.service.photo.impl;

import com.mmc.tmj.entity.database.PhotographDo;
import com.mmc.tmj.entity.result.PhotographListVo;
import com.mmc.tmj.mapper.PhotographDoRepository;
import com.mmc.tmj.service.photo.PhotographService;
import com.mmc.tmj.utils.BeanTransFormUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

/**
 * @Author lcz
 * @Date 2022/5/14 14:40
 * @Version 1.0
 * @description
 */
@Service
public class PhotographServiceImpl implements PhotographService {
    @Resource
    protected PhotographDoRepository photographDoRepository;

    @Override
    public void savePhotograph(PhotographDo photographDo) {
        photographDoRepository.save(photographDo);
    }

    @Override
    public List<PhotographListVo> getPhotographByTaskId(Integer taskId) {
        List<PhotographDo> allByTaskId = photographDoRepository.findAllByTaskId(taskId);
        return allByTaskId.stream().map(BeanTransFormUtil::transPhotographListVo).collect(Collectors.toList());
    }
}
