package com.mmc.tmj.mapper;

import com.mmc.tmj.entity.database.PhotographDo;
import com.mmc.tmj.entity.database.RouteDo;
import com.mmc.tmj.entity.param.RouteDataDto;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;

/**
 * @Author lcz
 * @Date 2022/5/9 9:46
 * @Version 1.0
 * @description
 */

public interface RouteRepository extends JpaRepository<RouteDo,Integer> , QuerydslPredicateExecutor<RouteDo> {

    public RouteDo findByName(String name);

    @Query(nativeQuery = true,value = "select count(1) from task_dto where task_status !=3 and route_name=:routeName")
    int checkTaskStatusByRouteName(@Param("routeName") String routeName);

}
