package com.mmc.tmj.entity.result;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import lombok.Data;

/**
 * @Author lcz
 * @Date 2022/5/18 13:57
 * @Version 1.0
 * @description
 */
@Data
public class TaskReportDto {
    /** 任务id */
    @ApiModelProperty(value = "任务id", example = "98")
    private Integer taskId;
    /** 任务名称 */
    @ApiModelProperty(value = "任务名称", example = "测试任务")
    private String taskName;
    /** 事故坐标 */
    @ApiModelProperty(value = "事故坐标", example = "11.33")
    private String location;
    /** 任务起始时间 */
    @ApiModelProperty(value = "任务起始时间", example = "2020-11-22")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime startTime;
    /** 任务结束时间 */
    @ApiModelProperty(value = "任务结束时间", example = "2020-11-25")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime endTime;
    /** 任务日期 */
    @ApiModelProperty(value = "任务日期", example = "2020-11-22")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime taskDate;
    /** 天气情况 */
    @ApiModelProperty(value = "天气情况", example = "晴天")
    private String weather;
    /** 设备编号（设备硬件Id） */
    @ApiModelProperty(value = "设备硬件Id", example = "aaa")
    private String deviceHardId;
    /** 执行人 */
    @ApiModelProperty(value = "执行人", example = "阿强")
    private String executePerson;
    /** 报告生成时间 */
    @ApiModelProperty(value = "报告生成时间", example = "2020-11-25")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime reportAddTime;
    /** 备注 */
    @ApiModelProperty(value = "备注", example = "666")
    private String remark;
}
