package com.mmc.tmj.entity.result;

import lombok.Getter;
import lombok.Setter;

/**
 * @Author lcz
 * @Date 2022/5/7 17:42
 * @Version 1.0
 * @description
 */
@Setter
@Getter
public class BaseResponse<T> {

    private static final int SERVER_ERROR = 500;

    /*状态码*/
    private int code = 200;
    /*描述信息*/
    private String msg;
    /*返回数据*/
    private T data;

    public static <T> BaseResponse<T> error() {
        return error("未知异常，请联系管理员", SERVER_ERROR);
    }

    public static <T> BaseResponse<T> error(T data) {
        BaseResponse<T> r = new BaseResponse<>();
        r.setData(data);
        return r;
    }

    public static <T> BaseResponse<T> error(String msg) {
        return error(msg, SERVER_ERROR);
    }

    public static <T> BaseResponse<T> error(String msg, int code) {
        return error(msg, code, null);
    }

    public static <T> BaseResponse<T> error(String msg, int code, T errors) {
        BaseResponse<T> r = new BaseResponse<>();
        r.setCode(code);
        r.setMsg(msg);
        r.setData(errors);
        return r;
    }

    public static <T> BaseResponse<T> ok(T data) {
        BaseResponse<T> r = new BaseResponse<>();
        r.setData(data);
        return r;
    }

    public static <T> BaseResponse<T> ok(String msg, T data) {
        BaseResponse<T> r = new BaseResponse<>();
        r.setMsg(msg);
        r.setData(data);
        return r;
    }

    public static <T> BaseResponse<T> ok(String msg, int code, T data) {
        BaseResponse<T> r = new BaseResponse<>();
        r.setMsg(msg);
        r.setCode(code);
        r.setData(data);
        return r;
    }
    // --------------------------------------------------------------------------------构造器End

    public static BaseResponse<Void> ok() {
        return new BaseResponse<>();
    }
}
