package com.mmc.tmj.entity.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * @Author lcz
 * @Date 2022/5/16 11:06
 * @Version 1.0
 * @description
 */
@Data
@ApiModel(description = "航点规划模型")
public class RoutePointDataDto {
    /** 航点唯一标识，由前端生成 */
    @ApiModelProperty(value = "航点唯一标识（请自行生成）", required = true, example = "xxxxxxxxx")
    private String uuid;

    @ApiModelProperty(value = "经度", required = true, example = "-10.56987")
    private Double longitude;
    @ApiModelProperty(value = "纬度", required = true, example = "-10.56987")
    private Double latitude;
    @ApiModelProperty(value = "海拔", required = true, example = "10.56987")
    @DecimalMin("1")
    @DecimalMax("150")
    private Double altitude;
    @ApiModelProperty(value = "偏航角", example = "10.56987")
    private Double yawAngle;
    @ApiModelProperty(value = "俯仰角", example = "10.56987")
    private Double pitchAngle;
    @ApiModelProperty(value = "航点速度（m/s）", example = "10")
    @DecimalMin("1")
    @DecimalMax("26")
    private Double speed;
    @Valid
    @NotNull
    private List<ActionWebDto> actions;

}
