package com.mmc.tmj.entity.other;

import com.mmc.tmj.enums.ActionType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import lombok.Data;

/**
 * @Author lcz
 * @Date 2022/5/16 15:03
 * @Version 1.0
 * @description
 */
@Data
@ApiModel(description = "航线上传格式")
public class RouteUploadDto {

    private String name;
    @DecimalMin("1")
    @DecimalMax("150")
    private Double defaultAltitude;
    @DecimalMin("1")
    @DecimalMax("26")
    private Double defaultSpeed;

    private Double defaultYawAngle;

    private Double defaultPitchAngle;

    private List<RoutePointUploadDto> points;
    @ApiModelProperty(value = "航线备注")
    private String remark;

    @Data
    @ApiModel(description = "航线内航点上传格式")
    public static class RoutePointUploadDto{
        @ApiModelProperty(value = "航点唯一标识（请自行生成）", required = true, example = "xxxxxxxxx")
        private String uuid;
        @ApiModelProperty(value = "经度（单位度），西经为负", example = "26.8764")
        private Double latitude;
        /** 纬度 */
        @ApiModelProperty(value = "纬度（单位度），南纬为负", example = "26.8764")
        private Double longitude;
        /** 高度（单位M） */
        @ApiModelProperty(value = "高度（单位M）", example = "20")
        @DecimalMin("1")
        @DecimalMax("150")
        private Double altitude;
        /** 偏航角度，目前单位都是度；暂时没有必要拆成值对象 */
        @ApiModelProperty(value = "偏航角度", example = "-20")
        private Double yawAngle;

        /** 俯仰角度，目前单位都是度；暂时没有必要拆成值对象 */
        @ApiModelProperty(value = "俯仰角度", example = "-20")
        private Double pitchAngle;
        /** 名称，描述 */
        @ApiModelProperty(value = "航点名称", example = "起始点")
        private String name;
        /** 巡检点动作 */
        private List<ActionUploadDto> actions;
        @DecimalMin("1")
        @DecimalMax("26")
        private Double speed;

    }

    @Data
    @ApiModel(description = "航线-航点内动作上传格式")
    public static class ActionUploadDto{
        @ApiModelProperty(value = "动作类型", required = true, example = "STAY")
        private ActionType type;
        /** 动作耗时，目前单位是second */
        @ApiModelProperty(value = "动作参数（单位s）", example = "6")
        private Integer takeSecond;
        /**
         * 拍照数量；
         *
         * <p>业务逻辑1、仅用于拍照动作 TODO
         */
        @ApiModelProperty(value = "照片拍摄数量", example = "6")
        private Integer takePhotoNumber;
    }

}
