package com.mmc.tmj.entity.other;

import com.mmc.tmj.utils.GpsUtils;
import lombok.Value;

/**
 * @Author lcz
 * @Date 2022/5/17 14:33
 * @Version 1.0
 * @description
 */
@Value
public class Position {
    /** 纬度,目前单位都是度 */
    private double latitude;
    /** 经度，目前单位都是度 */
    private double longitude;
    /** 海拔高度，可能叫elevation更为准确,目前海拔高度的单位都是米 */
    private double altitude;

    public double kmBetween(Position lastPosition) {
        return GpsUtils.getKmDistance(
            latitude, longitude, lastPosition.getLatitude(), lastPosition.getLongitude());
    }
}
