package com.mmc.tmj.entity.database;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

/**
 * @Author lcz
 * @Date 2022/5/9 9:48
 * @Version 1.0
 * @description
 */
@Entity
@Data
@DynamicUpdate
@DynamicInsert
public class TaskDto {
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Integer id;
    /** 任务名称 */
    private String taskName;
    /** 航线名称 */
    private String routeName;
    /** 责任单位名称 */
    private String organizationName;
    /** 设备id */
    private Integer deviceId;
    /** 设备名称 */
    private String deviceName;
    /** 设备硬件ID */
    private String deviceHardId;
    /** 设备在线状态（0：离线1：在线） */
    private Integer deviceStatus;
    /** 任务描述 */
    private String remark;
    /** 任务状态 */
    private Integer taskStatus;
    /** 经度 */
    // private String lng;
    /** 纬度 */
    // private String lat;
    /** 任务创建时间 */
    private String addTime;
    /** 任务开始时间 */
    private String startTime;
    /** 任务结束时间 */
    private String endTime;
}
