package com.mmc.tmj.entity.database;

import java.time.LocalDateTime;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Data;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

/**
 * @Author lcz
 * @Date 2022/5/16 10:12
 * @Version 1.0
 * @description
 */
@Entity
@Data
@Table(name = "route")
public class RouteDo {
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Integer id;

    private String name;

    private Double defaultAltitude;

    private Double defaultSpeed;

    private Double defaultYawAngle;

    private Double defaultPitchAngle;

    @OneToMany(
        cascade = {CascadeType.PERSIST, CascadeType.REMOVE, CascadeType.MERGE},
        fetch = FetchType.EAGER,
        orphanRemoval = false)
    @JoinColumn(name = "route_id")
    @Fetch(FetchMode.SUBSELECT)
    private List<RoutePointDo> points;

    private LocalDateTime createWhen;

    private String remark;

}
