package com.mmc.tmj.controller;

import com.mmc.tmj.entity.response.BaseNumListVo;
import com.mmc.tmj.entity.response.FlyManListMapVo;
import com.mmc.tmj.entity.response.TrainPointBaseInfo;
import com.mmc.tmj.entity.response.TrainPointListMapVo;
import com.mmc.tmj.entity.response.TrainPointListSimpleVo;
import com.mmc.tmj.entity.result.BaseResponse;
import com.mmc.tmj.utils.BeanTransFormUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author lcz
 * @Date 2022/5/21 16:57
 * @Version 1.0
 * @description
 */
@Api(tags = "培训网点")
@Validated
@Slf4j
@RequestMapping("/trainPoint")
@RestController
public class TrainPointController {
    @Autowired
    private Map<String, List<Map<String,Object>>> sumalationData;
    //@GetMapping("/getTrainPointNum")
    public BaseResponse<List<BaseNumListVo>> getTrainPointNum(@Valid @NotNull @RequestParam Integer accountId){

        return BaseResponse.ok(null);
    }

    @GetMapping("/getTrainPointListMap")
    @ApiOperation("获取培训网点数据列表")
    public BaseResponse<List<TrainPointListMapVo>> getTrainPointListMap(@Valid @NotNull @RequestParam Integer accountId){
        List<Map<String, Object>> flyer = sumalationData.get("train");
        final int[] i = {0};
        List<TrainPointListMapVo> mmc1 = flyer.stream().map((map) -> {
            i[0] = i[0] +1;
            return BeanTransFormUtil.transTrainPointListMapVoByMap(map, ""+i[0]);
        }).collect(Collectors.toList());
        return BaseResponse.ok(mmc1);
    }

    //@GetMapping("/getTrainPointListSimple")
    public BaseResponse<List<TrainPointListSimpleVo>> getTrainPointListSimple(@Valid @NotNull @RequestParam Integer accountId){

        return BaseResponse.ok(null);
    }

    //@GetMapping("/getTrainPointInfo")
    public BaseResponse<TrainPointBaseInfo> getTrainPointInfo(@Valid @NotNull @RequestParam Integer accountId,@Valid @NotNull @RequestParam Integer id){

        return BaseResponse.ok(null);
    }
}
