package com.mmc.tmj.controller;

import com.mmc.tmj.entity.response.BaseNumListVo;
import com.mmc.tmj.entity.response.FlyListMapVo;
import com.mmc.tmj.entity.response.FlyManListMapVo;
import com.mmc.tmj.entity.response.FlyManListSimpleVo;
import com.mmc.tmj.entity.result.BaseResponse;
import com.mmc.tmj.utils.BeanTransFormUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author lcz
 * @Date 2022/5/21 16:56
 * @Version 1.0
 * @description
 */
@Api(tags = "飞手")
@Validated
@Slf4j
@RequestMapping("/flyMan")
@RestController
public class FlyManController {
    @Autowired
    private Map<String, List<Map<String,Object>>> sumalationData;
    //@GetMapping("/getflyManNum")
    public BaseResponse<List<BaseNumListVo>> getflyManNum(@Valid @NotNull @RequestParam Integer accountId){

        return BaseResponse.ok(null);
    }

    @GetMapping("/getflyManListMap")
    @ApiOperation("获取飞手列表数据")
    public BaseResponse<List<FlyManListMapVo>> getflyManListMap(@Valid @NotNull @RequestParam Integer accountId){
        List<Map<String, Object>> flyer = sumalationData.get("flyer");
        final int[] i = {0};
        List<FlyManListMapVo> mmc1 = flyer.stream().map((map) -> {
            i[0] = i[0] +1;
            return BeanTransFormUtil.transFlyManListMapVoByMap(map, ""+i[0]);
        }).collect(Collectors.toList());
        return BaseResponse.ok(mmc1);
    }

    //@GetMapping("/getflyManListSimple")
    public BaseResponse<List<FlyManListSimpleVo>> getflyManListSimple(@Valid @NotNull @RequestParam Integer accountId){

        return BaseResponse.ok(null);
    }

}
