package com.mmc.tmj.controller;

import com.mmc.tmj.entity.other.DataObj;
import com.mmc.tmj.entity.other.LoginTokenInfo;
import com.mmc.tmj.entity.result.BaseResponse;
import com.mmc.tmj.entity.result.DeviceSelectDto;
import com.mmc.tmj.service.device.DeviceService;
import com.mmc.tmj.service.login.LoginService;
import com.mmc.tmj.utils.BeanTransFormUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author lcz
 * @Date 2022/5/12 9:55
 * @Version 1.0
 * @description
 */
@Api(tags = "设备")
@Validated
@Slf4j
@RequestMapping("/device")
@RestController
public class DeviceController {

    @Autowired
    private DeviceService deviceService;
    @Autowired
    private LoginService loginService;

    @ApiOperation("下拉列表显示设备")
    @GetMapping("/getDeviceSelect")
    public BaseResponse getDeviceSelect(@RequestParam @DecimalMin("1") int organizationId, HttpServletRequest request){
        //LoginTokenInfo token = loginService.getLoginInfo(request.getHeader("token"), "88990");
        DataObj dataObj = deviceService.getDeviceSelect(null,organizationId);
        return BaseResponse.ok(dataObj);
    }

    @ApiOperation("下拉显示未关联待执行状态任务的设备")
    @GetMapping("/unbindDevices")
    public BaseResponse<List<DeviceSelectDto>> unbindTaskDevices(@RequestParam @DecimalMin("1") int organizationId, HttpServletRequest request){
        //LoginTokenInfo token = loginService.getLoginInfo(request.getHeader("token"), "88990");
        DataObj dataObj = deviceService.getDeviceSelect(null,organizationId);
        return BaseResponse.ok(((List<Map<String, Object>>) dataObj).stream().filter(it-> null!=deviceService.deviceHaveTask((Integer) it.get("device_id"))).map(BeanTransFormUtil::transDeviceSelectDtoByDataObj).collect(
            Collectors.toList()));
    }

    @ApiOperation("判断设备是否有任务")
    @PostMapping("/deviceHaveTask")
    public BaseResponse<DataObj> deviceHaveTask(@RequestParam Integer id) {
        if(null != deviceService.deviceHaveTask(id)){
            return BaseResponse.ok(new DataObj("ok", "200", null));
        }
        return BaseResponse.error(new DataObj( "ok","400", null));
    }

    @ApiOperation("通过设备id更改设备名字")
    @PostMapping("/updateDeviceName")
    public BaseResponse deviceHaveTask(@RequestParam @NotNull String deviceHardId,@RequestParam @NotNull String deviceName,HttpServletRequest request) {
        //LoginTokenInfo token = loginService.getLoginInfo(request.getHeader("token"), "88990");
        String body=deviceService.updateDeviceName(null,deviceHardId,deviceName);
        return BaseResponse.ok(body);
    }

}
