package com.mmc.tmj.configuration;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mmc.tmj.utils.FileUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

/**
 * @Author lcz
 * @Date 2022/5/23 9:51
 * @Version 1.0
 * @description 模拟数据
 */
@Configuration
@Slf4j
public class SimulationConfiguration {
    @Autowired
    private ResourceLoader resourceLoader;

    @Autowired
    private ObjectMapper objectMapper;

    @Bean
    public Map<String, List<Map<String,Object>>> sumalationData() throws JsonProcessingException {
        Resource flyer = resourceLoader.getResource("classpath:/simulation_data/flyer.json");
        //Resource project = resourceLoader.getResource("classpath:/simulation_data/project.json");
        Resource service = resourceLoader.getResource("classpath:/simulation_data/service.json");
        Resource show = resourceLoader.getResource("classpath:/simulation_data/show.json");
        Resource train = resourceLoader.getResource("classpath:/simulation_data/train.json");
        Resource uav = resourceLoader.getResource("classpath:/simulation_data/uav.json");
        String flyerJson = FileUtils.jsonString(flyer);
        List<Map<String,Object>> flyerList = objectMapper.readValue(flyerJson, List.class);
        String serviceJson = FileUtils.jsonString(service);
        List<Map<String,Object>> serviceList = objectMapper.readValue(serviceJson, List.class);
        String showJson = FileUtils.jsonString(show);
        List<Map<String,Object>> showList = objectMapper.readValue(showJson, List.class);
        String trainJson = FileUtils.jsonString(train);
        List<Map<String,Object>> trainList = objectMapper.readValue(trainJson, List.class);
        String uavJson = FileUtils.jsonString(uav);
        List<Map<String,Object>> uavList = objectMapper.readValue(uavJson, List.class);

        System.out.println("flyerList={}"+ JSONObject.toJSONString(flyerList));
        System.out.println("serviceList={}"+ JSONObject.toJSONString(serviceList));
        System.out.println("showList={}"+ JSONObject.toJSONString(showList));
        System.out.println("trainList={}"+ JSONObject.toJSONString(trainList));
        System.out.println("uavList={}"+ JSONObject.toJSONString(uavList));

        Map<String,List<Map<String,Object>>> map = new HashMap();
        map.put("flyer",flyerList);
        map.put("service",serviceList);
        map.put("show",showList);
        map.put("train",trainList);
        map.put("uav",uavList);
        System.out.println("sumalationData={}"+ JSONObject.toJSONString(map));
        return map;
    }

}
