package com.mmc.tmj.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;

/**
 * @Author lcz
 * @Date 2022/4/8 9:42
 * @Version 1.0
 * @description
 */
@Configuration
public class RedisTemplateConfiguration {

    @Value("${spring.redis.host}")
    private String orderHost;
    @Value("${spring.redis.port}")
    private String orderPort;
    @Value("${spring.redis.password}")
    private String orderPassword;


    //最大空闲连接数
    private static final int MAX_IDLE =200;
    //最大连接数
    private static final int MAX_TOTAL =1024;
    //建立连接等待时长
    private static final long MAX_WAIT_MILLIS = 10000;

    //配置工厂
    public RedisConnectionFactory connectionFactory(String host, int port, String password, int maxIdle,
        int maxTotal, long maxWaitMillis, int index) {
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory();
        jedisConnectionFactory.setHostName(host);
        jedisConnectionFactory.setPort(port);

        if (!StringUtils.isEmpty(password)) {
            jedisConnectionFactory.setPassword(password);
        }

        if (index != 0) {
            jedisConnectionFactory.setDatabase(index);
        }

        jedisConnectionFactory.setPoolConfig(poolConfig(maxIdle, maxTotal, maxWaitMillis, false));
        jedisConnectionFactory.afterPropertiesSet();
        return jedisConnectionFactory;
    }

    //连接池配置
    public JedisPoolConfig poolConfig(int maxIdle, int maxTotal, long maxWaitMillis, boolean testOnBorrow) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(maxIdle);
        poolConfig.setMaxTotal(maxTotal);
        poolConfig.setMaxWaitMillis(maxWaitMillis);
        poolConfig.setTestOnBorrow(testOnBorrow);
        return poolConfig;
    }


    //------------------------------------
    @Bean(name = "redisOrderTemplate")
    public StringRedisTemplate redisOrderTemplate() {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(
            connectionFactory(orderHost, Integer.parseInt(orderPort), orderPassword, MAX_IDLE, MAX_TOTAL, MAX_WAIT_MILLIS, 0));
        //OptUtil.redisTemplate0 = template;
        return template;
    }

    //------------------------------------
    @Bean(name = "redisUserTemplate")
    public StringRedisTemplate userUserTemplate() {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(
            connectionFactory(orderHost, Integer.parseInt(orderPort), orderPassword, MAX_IDLE, MAX_TOTAL, MAX_WAIT_MILLIS, 2));
        //OptUtil.redisTemplate2 = template;
        return template;
    }



}
