package com.mmc.tmj.configuration;

import io.minio.MinioClient;
import lombok.SneakyThrows;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @Author lcz
 * @Date 2022/5/14 15:04
 * @Version 1.0
 * @description
 */
@Configuration
@EnableConfigurationProperties(MinioPropConfiguration.class)
public class MinioConfiguration {
    @Autowired
    private MinioPropConfiguration minioPropConfiguration;

    @SneakyThrows
    @Bean
    public MinioClient minioClient(){
        return new MinioClient(minioPropConfiguration.getEndpoint(),minioPropConfiguration.getAccesskey(),minioPropConfiguration.getSecretkey());
    }


}
