package com.mmc.tmj.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @Author lcz
 * @Date 2022/5/18 16:21
 * @Version 1.0
 * @description
 */
@Configuration
public class GloableCrorsConfig implements WebMvcConfigurer {
    @Override
    public void addCorsMappings(CorsRegistry registry) {
        registry
            .addMapping("/**")
            .exposedHeaders("token")
            .allowedOriginPatterns("*")
            .allowedMethods("HEAD", "POST", "GET", "PUT", "OPTIONS", "DELETE", "PATCH")
            .maxAge(168000)
            .allowedHeaders("*")
            .allowCredentials(true);
    }
}
