package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.database.ActionDo;
import com.mmc.tmj.entity.database.RoutePointDo;
import com.mmc.tmj.utils.builder.statement.RoutePointDoStatementTmBuilder;
import java.util.List;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/16 11:25
 * @Version 1.0
 * @description
 */
public class RoutePointDoTmBuilder extends RoutePointDoStatementTmBuilder<RoutePointDo> {
    public static RoutePointDoTmBuilder getInstance(){
        return new RoutePointDoTmBuilder();
    }
    @Override
    public RoutePointDo getObject() {
        return routePointDo;
    }

    @Override
    public RoutePointDoTmBuilder init(RoutePointDo object) {
        routePointDo=object;
        return this;
    }

    @Override
    public RoutePointDoTmBuilder init() {
        routePointDo=new RoutePointDo();
        return this;
    }

    @Override
    public RoutePointDoTmBuilder buildId(Integer id) {
        Optional.ofNullable(id).ifPresent(inte ->{
            this.routePointDo.setId(inte);
        });
        return this;
    }

    @Override
    public RoutePointDoTmBuilder buildUuid(String uuid) {
        Optional.ofNullable(uuid).ifPresent(inte ->{
            this.routePointDo.setUuid(inte);
        });
        return this;
    }

    @Override
    public RoutePointDoTmBuilder buildLatitude(Double latitude) {
        this.routePointDo.setLatitude(Optional.ofNullable(latitude).orElse(0.0));
        return this;
    }

    @Override
    public RoutePointDoTmBuilder buildLongitude(Double longitude) {
        this.routePointDo.setLongitude(Optional.ofNullable(longitude).orElse(0.0));
        return this;
    }

    @Override
    public RoutePointDoTmBuilder buildAltitude(Double altitude) {
        this.routePointDo.setAltitude(Optional.ofNullable(altitude).orElse(100.0));
        return this;
    }

    @Override
    public RoutePointDoTmBuilder buildYawAngle(Double yawAngle) {
        this.routePointDo.setYawAngle(Optional.ofNullable(yawAngle).orElse(0.0));
        return this;
    }

    @Override
    public RoutePointDoTmBuilder buildPitchAngle(Double pitchAngle) {
        this.routePointDo.setPitchAngle(Optional.ofNullable(pitchAngle).orElse(0.0));
        return this;
    }

    @Override
    public RoutePointDoTmBuilder buildSpeed(Double speed) {
        this.routePointDo.setSpeed(Optional.ofNullable(speed).orElse(3.0));
        return this;
    }

    @Override
    public RoutePointDoTmBuilder buildActions(List<ActionDo> actions) {
        this.routePointDo.setActions(actions);
        return this;
    }
}
