package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.database.RouteDo;
import com.mmc.tmj.entity.database.RoutePointDo;
import com.mmc.tmj.utils.builder.statement.RouteDoStatementTmBuilder;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/16 10:52
 * @Version 1.0
 * @description
 */
public class RouteDoTmBuilder extends RouteDoStatementTmBuilder<RouteDo> {
    public static RouteDoTmBuilder getInstance(){
        return new RouteDoTmBuilder();
    }
    @Override
    public RouteDo getObject() {
        return routeDo;
    }

    @Override
    public RouteDoTmBuilder init(RouteDo object) {
        this.routeDo=object;
        return this;
    }

    @Override
    public RouteDoTmBuilder init() {
        this.routeDo=new RouteDo();
        return this;
    }

    @Override
    public RouteDoTmBuilder buildId(Integer id) {
        Optional.ofNullable(id).ifPresent(inte ->{
            this.routeDo.setId(inte);
        });
        return this;
    }

    @Override
    public RouteDoTmBuilder buildName(String name) {
        Optional.ofNullable(name).ifPresent(inte ->{
            this.routeDo.setName(inte);
        });
        return this;
    }

    @Override
    public RouteDoTmBuilder buildDefaultAltitude(Double defaultAltitude) {
        this.routeDo.setDefaultAltitude(Optional.ofNullable(defaultAltitude).orElse(0.0));
        return this;
    }

    @Override
    public RouteDoTmBuilder buildDefaultSpeed(Double defaultSpeed) {
        this.routeDo.setDefaultSpeed(Optional.ofNullable(defaultSpeed).orElse(0.0));
        return this;
    }

    @Override
    public RouteDoTmBuilder buildDefaultYawAngle(Double defaultYawAngle) {
        this.routeDo.setDefaultYawAngle(Optional.ofNullable(defaultYawAngle).orElse(0.0));
        return this;
    }

    @Override
    public RouteDoTmBuilder buildDefaultPitchAngle(Double defaultPitchAngle) {
        this.routeDo.setDefaultPitchAngle(Optional.ofNullable(defaultPitchAngle).orElse(0.0));
        return this;
    }

    @Override
    public RouteDoTmBuilder buildPoints(List<RoutePointDo> points) {
        this.routeDo.setPoints(points);
        return this;
    }

    @Override
    public RouteDoTmBuilder buildCreateWhen(LocalDateTime createWhen) {
        Optional.ofNullable(createWhen).ifPresent(inte ->{
            this.routeDo.setCreateWhen(inte);
        });
        return this;
    }

    @Override
    public RouteDoTmBuilder buildRemark(String remark) {
        Optional.ofNullable(remark).ifPresent(inte ->{
            this.routeDo.setRemark(inte);
        });
        return this;
    }
}
