package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.database.PhotographDo;
import com.mmc.tmj.entity.result.PhotographListVo;
import com.mmc.tmj.utils.builder.statement.PhotographDoStatementTmBuilder;
import com.mmc.tmj.utils.builder.statement.PhotographListVoStatementTmBuilder;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/9 10:19
 * @Version 1.0
 * @description
 */
public class PhotographListVoTmBuilder extends PhotographListVoStatementTmBuilder<PhotographListVo> {

    public static PhotographListVoTmBuilder getInstance(){
        return new PhotographListVoTmBuilder();
    }


    @Override
    public PhotographListVo getObject() {
        return photographListVo;
    }

    @Override
    public PhotographListVoTmBuilder init(PhotographListVo object) {
        photographListVo=object;
        return this;
    }

    @Override
    public PhotographListVoTmBuilder init() {
        photographListVo=new PhotographListVo();
        return this;
    }

    @Override
    public PhotographListVoTmBuilder buildImages(String image) {
        Optional.ofNullable(image).ifPresent(inte ->{
            this.photographListVo.setImages(inte);
        });
        return this;
    }

    @Override
    public PhotographListVoTmBuilder buildCreateTime(String createTime) {
        Optional.ofNullable(createTime).ifPresent(inte ->{
            this.photographListVo.setCreateTime(inte);
        });
        return null;
    }
}
