package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.database.PhotographDo;
import com.mmc.tmj.entity.result.TaskSelectVo;
import com.mmc.tmj.utils.builder.statement.PhotographDoStatementTmBuilder;
import com.mmc.tmj.utils.builder.statement.TaskSelectVoStatementTmBuilder;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/9 10:19
 * @Version 1.0
 * @description
 */
public class PhotographDoTmBuilder extends PhotographDoStatementTmBuilder<PhotographDo> {

    public static PhotographDoTmBuilder getInstance(){
        return new PhotographDoTmBuilder();
    }


    @Override
    public PhotographDo getObject() {
        return photographDo;
    }

    @Override
    public PhotographDoTmBuilder init(PhotographDo object) {
        photographDo=object;
        return this;
    }

    @Override
    public PhotographDoTmBuilder init() {
        photographDo=new PhotographDo();
        return this;
    }

    @Override
    public PhotographDoTmBuilder buildId(Integer id) {
        Optional.ofNullable(id).ifPresent(inte ->{
            this.photographDo.setId(inte);
        });
        return this;
    }

    @Override
    public PhotographDoTmBuilder buildTaskId(Integer taskId) {
        Optional.ofNullable(taskId).ifPresent(inte ->{
            this.photographDo.setTaskId(inte);
        });
        return this;
    }

    @Override
    public PhotographDoTmBuilder buildImages(String image) {
        Optional.ofNullable(image).ifPresent(inte ->{
            this.photographDo.setImages(inte);
        });
        return this;
    }

    @Override
    public PhotographDoTmBuilder buildDeviceHardId(String deviceHardId) {
        Optional.ofNullable(deviceHardId).ifPresent(inte ->{
            this.photographDo.setDeviceHardId(inte);
        });
        return null;
    }

    @Override
    public PhotographDoTmBuilder buildCreateTime(String createTime) {
        Optional.ofNullable(createTime).ifPresent(inte ->{
            this.photographDo.setCreateTime(inte);
        });
        return null;
    }
}
