package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.database.ActionDo;
import com.mmc.tmj.entity.other.RouteUploadDto.ActionUploadDto;
import com.mmc.tmj.enums.ActionType;
import com.mmc.tmj.utils.builder.statement.ActionDoStatementTmBuilder;
import com.mmc.tmj.utils.builder.statement.ActionUploadDtoStatementTmBuilder;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/16 11:42
 * @Version 1.0
 * @description
 */
public class ActionUploadDtoTmBuilder extends ActionUploadDtoStatementTmBuilder<ActionUploadDto> {
    public static ActionUploadDtoTmBuilder getInstance(){
        return new ActionUploadDtoTmBuilder();
    }
    @Override
    public ActionUploadDto getObject() {
        return actionUploadDto;
    }

    @Override
    public ActionUploadDtoTmBuilder init(ActionUploadDto object) {
        actionUploadDto = object;
        return this;
    }

    @Override
    public ActionUploadDtoTmBuilder init() {
        actionUploadDto = new ActionUploadDto();
        return this;
    }


    @Override
    public ActionUploadDtoTmBuilder buildActionType(ActionType actionType) {
        Optional.ofNullable(actionType).ifPresent(inte ->{
            this.actionUploadDto.setType(inte);
        });
        return this;
    }

    @Override
    public ActionUploadDtoTmBuilder buildTakeSecond(Integer takeSecond) {
        this.actionUploadDto.setTakeSecond(Optional.ofNullable(takeSecond).orElse(0));
        return this;
    }
}
