package com.mmc.tmj.utils.builder.statement;

import com.mmc.tmj.entity.database.TrackDo;
import com.mmc.tmj.entity.result.TaskReportDto;
import com.mmc.tmj.utils.builder.TmBuilder;
import java.time.LocalDateTime;


/**
 * @Author lcz
 * @Date 2022/5/9 10:16
 * @Version 1.0
 * @description
 */
public abstract class TaskReportDtoStatementTmBuilder<T> extends TmBuilder<TaskReportDto> {
    protected TaskReportDto taskReportDto = new TaskReportDto();

    @Override
    public abstract TaskReportDtoStatementTmBuilder init(TaskReportDto object);

    @Override
    public abstract TaskReportDtoStatementTmBuilder init();

    public abstract TaskReportDtoStatementTmBuilder buildTaskId(Integer taskId);

    public abstract TaskReportDtoStatementTmBuilder buildTaskName(String taskName);

    public abstract TaskReportDtoStatementTmBuilder buildLocation(String location);

    public abstract TaskReportDtoStatementTmBuilder buildStartTime(LocalDateTime startTime);

    public abstract TaskReportDtoStatementTmBuilder buildEndTime(LocalDateTime endTime);

    public abstract TaskReportDtoStatementTmBuilder buildTaskDate(LocalDateTime taskDate);

    public abstract TaskReportDtoStatementTmBuilder buildWeather(String weather);

    public abstract TaskReportDtoStatementTmBuilder buildDeviceHardId(String deviceHardId);

    public abstract TaskReportDtoStatementTmBuilder buildExecutePerson(String executePerson);

    public abstract TaskReportDtoStatementTmBuilder buildReportAddTime(LocalDateTime reportAddTime);

    public abstract TaskReportDtoStatementTmBuilder buildRemark(String remark);


}
