package com.mmc.tmj.utils.builder.statement;

import com.mmc.tmj.entity.database.RouteDo;
import com.mmc.tmj.entity.database.RoutePointDo;
import com.mmc.tmj.entity.result.TaskInfoVo;
import com.mmc.tmj.utils.builder.TmBuilder;
import java.time.LocalDateTime;
import java.util.List;


/**
 * @Author lcz
 * @Date 2022/5/9 10:16
 * @Version 1.0
 * @description
 */
public abstract class RouteDoStatementTmBuilder<T> extends TmBuilder<RouteDo> {
    protected RouteDo routeDo = new RouteDo();

    @Override
    public abstract RouteDoStatementTmBuilder init(RouteDo object);

    @Override
    public abstract RouteDoStatementTmBuilder init();

    public abstract RouteDoStatementTmBuilder buildId(Integer id);

    public abstract RouteDoStatementTmBuilder buildName(String name);

    public abstract RouteDoStatementTmBuilder buildDefaultAltitude(Double defaultAltitude);

    public abstract RouteDoStatementTmBuilder buildDefaultSpeed(Double defaultSpeed);

    public abstract RouteDoStatementTmBuilder buildDefaultYawAngle(Double defaultYawAngle);

    public abstract RouteDoStatementTmBuilder buildDefaultPitchAngle(Double defaultPitchAngle);

    public abstract RouteDoStatementTmBuilder buildPoints(List<RoutePointDo> points);

    public abstract RouteDoStatementTmBuilder buildCreateWhen(LocalDateTime createWhen);

    public abstract RouteDoStatementTmBuilder buildRemark(String remark);




}
